/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.threading;

import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSynchronizedStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.ui.AddAction;
import com.siyeh.ig.ui.IGTable;
import com.siyeh.ig.ui.ListWrappingTableModel;
import com.siyeh.ig.ui.RemoveAction;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.jdom.Element;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AccessToNonThreadSafeStaticFieldFromInstanceInspection
extends BaseInspection {
    @NonNls
    public String nonThreadSafeTypes = "java.text.DateFormat,java.util.Calendar";
    List<String> nonThreadSafeTypeList = new ArrayList<String>();

    public AccessToNonThreadSafeStaticFieldFromInstanceInspection() {
        AccessToNonThreadSafeStaticFieldFromInstanceInspection.parseString(this.nonThreadSafeTypes, this.nonThreadSafeTypeList);
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("access.to.non.thread.safe.static.field.from.instance.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/threading/AccessToNonThreadSafeStaticFieldFromInstanceInspection.getDisplayName must not return null");
        }
        return string;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string;
        if (infos[0] instanceof PsiMethod) {
            string = InspectionGadgetsBundle.message("access.to.non.thread.safe.static.field.from.instance.method.problem.descriptor", infos[1]);
            if (string == null) throw new IllegalStateException("@NotNull method com/siyeh/ig/threading/AccessToNonThreadSafeStaticFieldFromInstanceInspection.buildErrorString must not return null");
            return string;
        }
        string = InspectionGadgetsBundle.message("access.to.non.thread.safe.static.field.from.instance.field.problem.descriptor", infos[1]);
        if (string != null) return string;
        throw new IllegalStateException("@NotNull method com/siyeh/ig/threading/AccessToNonThreadSafeStaticFieldFromInstanceInspection.buildErrorString must not return null");
    }

    @Nullable
    public JComponent createOptionsPanel() {
        Form form = new Form();
        return form.getContentPanel();
    }

    public void readSettings(Element node) throws InvalidDataException {
        super.readSettings(node);
        AccessToNonThreadSafeStaticFieldFromInstanceInspection.parseString(this.nonThreadSafeTypes, this.nonThreadSafeTypeList);
    }

    public void writeSettings(Element node) throws WriteExternalException {
        this.nonThreadSafeTypes = AccessToNonThreadSafeStaticFieldFromInstanceInspection.formatString(this.nonThreadSafeTypeList);
        super.writeSettings(node);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new AccessToNonThreadSafeStaticFieldFromInstanceVisitor();
    }

    private class Form {
        private IGTable table;
        private JButton addButton;
        private JButton removeButton;
        private JPanel contentPanel;

        Form() {
            this.$$$setupUI$$$();
            this.addButton.setAction(new AddAction(this.table));
            this.removeButton.setAction(new RemoveAction(this.table));
        }

        private void createUIComponents() {
            this.table = new IGTable(new ListWrappingTableModel(AccessToNonThreadSafeStaticFieldFromInstanceInspection.this.nonThreadSafeTypeList, InspectionGadgetsBundle.message("non.thread.safe.types.column.name", new Object[0])));
        }

        public JComponent getContentPanel() {
            return this.contentPanel;
        }

        private /* synthetic */ void $$$setupUI$$$() {
            JButton jButton;
            JButton jButton2;
            JPanel jPanel;
            this.createUIComponents();
            this.contentPanel = jPanel = new JPanel();
            jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(4, 4, 4, 4), 4, 4, false, false));
            JScrollPane jScrollPane = new JScrollPane();
            jPanel.add((Component)jScrollPane, new GridConstraints(0, 0, 3, 1, 0, 3, 7, 7, null, null, null));
            IGTable iGTable = this.table;
            jScrollPane.setViewportView((Component)((Object)iGTable));
            this.addButton = jButton2 = new JButton();
            jButton2.setText("Button");
            jPanel.add((Component)jButton2, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 0, null, null, null));
            Spacer spacer = new Spacer();
            jPanel.add((Component)spacer, new GridConstraints(2, 1, 1, 1, 0, 2, 1, 6, null, null, null));
            this.removeButton = jButton = new JButton();
            jButton.setText("Button");
            jPanel.add((Component)jButton, new GridConstraints(1, 1, 1, 1, 0, 1, 3, 0, null, null, null));
        }

        public /* synthetic */ JComponent $$$getRootComponent$$$() {
            return this.contentPanel;
        }
    }

    private class AccessToNonThreadSafeStaticFieldFromInstanceVisitor
    extends BaseInspectionVisitor {
        private AccessToNonThreadSafeStaticFieldFromInstanceVisitor() {
        }

        @Override
        public void visitReferenceExpression(PsiReferenceExpression expression) {
            PsiExpression qualifier;
            super.visitReferenceExpression(expression);
            PsiModifierListOwner parent = (PsiModifierListOwner)PsiTreeUtil.getParentOfType((PsiElement)expression, (Class[])new Class[]{PsiField.class, PsiMethod.class, PsiClassInitializer.class});
            if (parent == null) {
                return;
            }
            if (parent.hasModifierProperty("static")) {
                return;
            }
            if (parent instanceof PsiMethod || parent instanceof PsiClassInitializer) {
                if (parent.hasModifierProperty("synchronized")) {
                    return;
                }
                PsiSynchronizedStatement synchronizedStatement = (PsiSynchronizedStatement)PsiTreeUtil.getParentOfType((PsiElement)expression, PsiSynchronizedStatement.class);
                if (synchronizedStatement != null) {
                    return;
                }
            }
            if ((qualifier = expression.getQualifierExpression()) != null) {
                return;
            }
            PsiType type = expression.getType();
            if (type == null) {
                return;
            }
            String typeString = null;
            for (String nonThreadSafeType : AccessToNonThreadSafeStaticFieldFromInstanceInspection.this.nonThreadSafeTypeList) {
                if (!type.equalsToText(nonThreadSafeType)) continue;
                typeString = nonThreadSafeType;
                break;
            }
            if (typeString == null) {
                return;
            }
            PsiElement target = expression.resolve();
            if (!(target instanceof PsiField)) {
                return;
            }
            PsiField field = (PsiField)target;
            if (!field.hasModifierProperty("static")) {
                return;
            }
            this.registerError((PsiElement)expression, parent, typeString);
        }
    }
}

