/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.style;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.VariableSearchUtils;
import org.jetbrains.annotations.NotNull;

public class UnnecessaryBlockStatementInspection
extends BaseInspection {
    @NotNull
    public String getID() {
        if ("UnnecessaryCodeBlock" == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/style/UnnecessaryBlockStatementInspection.getID must not return null");
        }
        return "UnnecessaryCodeBlock";
    }

    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("unnecessary.code.block.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/style/UnnecessaryBlockStatementInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("unnecessary.block.statement.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/style/UnnecessaryBlockStatementInspection.buildErrorString must not return null");
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new UnnecessaryBlockStatementVisitor();
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new UnnecessaryBlockFix();
    }

    private static class UnnecessaryBlockStatementVisitor
    extends BaseInspectionVisitor {
        private UnnecessaryBlockStatementVisitor() {
        }

        public void visitBlockStatement(PsiBlockStatement blockStatement) {
            super.visitBlockStatement(blockStatement);
            PsiElement parent = blockStatement.getParent();
            if (!(parent instanceof PsiCodeBlock)) {
                return;
            }
            PsiCodeBlock codeBlock = blockStatement.getCodeBlock();
            PsiJavaToken brace = codeBlock.getLBrace();
            if (brace == null) {
                return;
            }
            PsiCodeBlock parentBlock = (PsiCodeBlock)parent;
            if (parentBlock.getStatements().length > 1 && VariableSearchUtils.containsConflictingDeclarations(codeBlock, parentBlock)) {
                return;
            }
            this.registerError((PsiElement)brace, new Object[0]);
            PsiJavaToken rbrace = codeBlock.getRBrace();
            if (rbrace != null) {
                this.registerError((PsiElement)rbrace, new Object[0]);
            }
        }
    }

    private static class UnnecessaryBlockFix
    extends InspectionGadgetsFix {
        private UnnecessaryBlockFix() {
        }

        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("unnecessary.code.block.unwrap.quickfix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException("@NotNull method com/siyeh/ig/style/UnnecessaryBlockStatementInspection$UnnecessaryBlockFix.getName must not return null");
            }
            return string;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiElement leftBrace = descriptor.getPsiElement();
            PsiElement parent = leftBrace.getParent();
            if (!(parent instanceof PsiCodeBlock)) {
                return;
            }
            PsiCodeBlock block = (PsiCodeBlock)parent;
            PsiBlockStatement blockStatement = (PsiBlockStatement)block.getParent();
            PsiElement[] children = block.getChildren();
            if (children.length > 2) {
                PsiElement element = blockStatement.getParent();
                element.addRangeBefore(children[1], children[children.length - 2], (PsiElement)blockStatement);
            }
            blockStatement.delete();
        }
    }
}

