/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.security;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.ConstantExpressionUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ClassUtils;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class JDBCPrepareStatementWithNonConstantStringInspection
extends BaseInspection {
    @NonNls
    private static final Set<String> s_execMethodNames = new HashSet<String>(2);

    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("jdbc.prepare.statement.with.non.constant.string.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/security/JDBCPrepareStatementWithNonConstantStringInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("jdbc.prepare.statement.with.non.constant.string.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/security/JDBCPrepareStatementWithNonConstantStringInspection.buildErrorString must not return null");
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new RuntimeExecVisitor();
    }

    static {
        s_execMethodNames.add("prepareStatement");
        s_execMethodNames.add("prepareCall");
    }

    private static class RuntimeExecVisitor
    extends BaseInspectionVisitor {
        private RuntimeExecVisitor() {
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/security/JDBCPrepareStatementWithNonConstantStringInspection$RuntimeExecVisitor.visitMethodCallExpression must not be null");
            }
            super.visitMethodCallExpression(expression);
            PsiReferenceExpression methodExpression = expression.getMethodExpression();
            String methodName = methodExpression.getReferenceName();
            if (!s_execMethodNames.contains(methodName)) {
                return;
            }
            PsiMethod method = expression.resolveMethod();
            if (method == null) {
                return;
            }
            PsiClass aClass = method.getContainingClass();
            if (aClass == null) {
                return;
            }
            if (!ClassUtils.isSubclass(aClass, "java.sql.Connection")) {
                return;
            }
            PsiExpressionList argumentList = expression.getArgumentList();
            PsiExpression[] args = argumentList.getExpressions();
            if (args.length == 0) {
                return;
            }
            PsiExpression arg = args[0];
            PsiType type = arg.getType();
            if (type == null) {
                return;
            }
            String typeText = type.getCanonicalText();
            if (!"java.lang.String".equals(typeText)) {
                return;
            }
            String stringValue = (String)ConstantExpressionUtil.computeCastTo((PsiExpression)arg, (PsiType)type);
            if (stringValue != null) {
                return;
            }
            this.registerMethodCallError(expression, new Object[0]);
        }
    }
}

