/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.resources;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.resources.ResourceInspection;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class JDBCResourceInspection
extends ResourceInspection {
    private static final String[] creationMethodClassName = new String[]{"java.sql.Driver", "java.sql.DriverManager", "javax.sql.DataSource", "java.sql.Connection", "java.sql.Connection", "java.sql.Connection", "java.sql.Statement", "java.sql.Statement", "java.sql.Statement"};
    @NonNls
    private static final String[] creationMethodName = new String[]{"connect", "getConnection", "getConnection", "createStatement", "prepareStatement", "prepareCall", "executeQuery", "getResultSet", "getGeneratedKeys"};
    private static final Set<String> creationMethodNameSet = new HashSet<String>(9);

    @NotNull
    public String getID() {
        if ("JDBCResourceOpenedButNotSafelyClosed" == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/resources/JDBCResourceInspection.getID must not return null");
        }
        return "JDBCResourceOpenedButNotSafelyClosed";
    }

    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("jdbc.resource.opened.not.closed.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/resources/JDBCResourceInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        PsiExpression expression = (PsiExpression)infos[0];
        PsiType type = expression.getType();
        assert (type != null);
        String text = type.getPresentableText();
        String string = InspectionGadgetsBundle.message("jdbc.resource.opened.not.closed.problem.descriptor", text);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/resources/JDBCResourceInspection.buildErrorString must not return null");
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new JDBCResourceVisitor();
    }

    static {
        creationMethodNameSet.addAll(Arrays.asList(creationMethodName));
    }

    private static class JDBCResourceVisitor
    extends BaseInspectionVisitor {
        private JDBCResourceVisitor() {
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/resources/JDBCResourceInspection$JDBCResourceVisitor.visitMethodCallExpression must not be null");
            }
            super.visitMethodCallExpression(expression);
            if (!JDBCResourceVisitor.isJDBCResourceCreation(expression)) {
                return;
            }
            PsiElement parent = ResourceInspection.getExpressionParent((PsiExpression)expression);
            if (parent instanceof PsiReturnStatement) {
                return;
            }
            PsiVariable boundVariable = ResourceInspection.getVariable(parent);
            if (ResourceInspection.isSafelyClosed(boundVariable, (PsiExpression)expression)) {
                return;
            }
            if (ResourceInspection.isResourceEscapedFromMethod(boundVariable, (PsiElement)expression)) {
                return;
            }
            this.registerError((PsiElement)expression, expression);
        }

        private static boolean isJDBCResourceCreation(PsiMethodCallExpression expression) {
            PsiReferenceExpression methodExpression = expression.getMethodExpression();
            String name = methodExpression.getReferenceName();
            if (name == null) {
                return false;
            }
            if (!creationMethodNameSet.contains(name)) {
                return false;
            }
            PsiMethod method = expression.resolveMethod();
            if (method == null) {
                return false;
            }
            for (int i = 0; i < creationMethodName.length; ++i) {
                if (!name.equals(creationMethodName[i])) continue;
                PsiClass containingClass = method.getContainingClass();
                if (containingClass == null) {
                    return false;
                }
                String className = containingClass.getQualifiedName();
                if (className == null) {
                    return false;
                }
                if (!className.equals(creationMethodClassName[i])) continue;
                return true;
            }
            return false;
        }
    }
}

