/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.naming;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiVariable;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.RenameFix;
import org.jetbrains.annotations.NotNull;

public class DollarSignInNameInspection
extends BaseInspection {
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("dollar.sign.in.name.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/naming/DollarSignInNameInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new RenameFix();
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("dollar.sign.in.name.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/naming/DollarSignInNameInspection.buildErrorString must not return null");
        }
        return string;
    }

    @Override
    protected boolean buildQuickFixesOnlyForOnTheFlyErrors() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new DollarSignInNameVisitor();
    }

    private static class DollarSignInNameVisitor
    extends BaseInspectionVisitor {
        private DollarSignInNameVisitor() {
        }

        public void visitVariable(@NotNull PsiVariable variable) {
            if (variable == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/naming/DollarSignInNameInspection$DollarSignInNameVisitor.visitVariable must not be null");
            }
            super.visitVariable(variable);
            String name = variable.getName();
            if (name == null) {
                return;
            }
            if (name.indexOf(36) < 0) {
                return;
            }
            this.registerVariableError(variable, new Object[0]);
        }

        public void visitMethod(@NotNull PsiMethod method) {
            if (method == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/naming/DollarSignInNameInspection$DollarSignInNameVisitor.visitMethod must not be null");
            }
            super.visitMethod(method);
            String name = method.getName();
            if (name.indexOf(36) < 0) {
                return;
            }
            this.registerMethodError(method, new Object[0]);
        }

        public void visitClass(@NotNull PsiClass aClass) {
            if (aClass == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/naming/DollarSignInNameInspection$DollarSignInNameVisitor.visitClass must not be null");
            }
            String name = aClass.getName();
            if (name == null) {
                return;
            }
            if (name.indexOf(36) < 0) {
                return;
            }
            this.registerClassError(aClass, new Object[0]);
        }
    }
}

