/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.memory;

import com.intellij.psi.PsiField;
import com.intellij.psi.PsiType;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import org.jetbrains.annotations.NotNull;

public class StringBufferFieldInspection
extends BaseInspection {
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("stringbuffer.field.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/memory/StringBufferFieldInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        PsiType type = (PsiType)infos[0];
        String typeName = type.getPresentableText();
        String string = InspectionGadgetsBundle.message("stringbuffer.field.problem.descriptor", typeName);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/memory/StringBufferFieldInspection.buildErrorString must not return null");
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new StringBufferFieldVisitor();
    }

    private static class StringBufferFieldVisitor
    extends BaseInspectionVisitor {
        private StringBufferFieldVisitor() {
        }

        public void visitField(@NotNull PsiField field) {
            if (field == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/memory/StringBufferFieldInspection$StringBufferFieldVisitor.visitField must not be null");
            }
            super.visitField(field);
            PsiType type = field.getType();
            if (!type.equalsToText("java.lang.StringBuffer") && !type.equalsToText("java.lang.StringBuilder")) {
                return;
            }
            this.registerFieldError(field, type);
        }
    }
}

