/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.junit;

import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSuperExpression;
import org.jetbrains.annotations.NotNull;

class CallToSuperSetupVisitor
extends JavaRecursiveElementVisitor {
    private boolean callToSuperSetupFound = false;

    CallToSuperSetupVisitor() {
    }

    public void visitElement(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/junit/CallToSuperSetupVisitor.visitElement must not be null");
        }
        if (!this.callToSuperSetupFound) {
            super.visitElement(element);
        }
    }

    public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/junit/CallToSuperSetupVisitor.visitMethodCallExpression must not be null");
        }
        if (this.callToSuperSetupFound) {
            return;
        }
        super.visitMethodCallExpression(expression);
        PsiReferenceExpression methodExpression = expression.getMethodExpression();
        String methodName = methodExpression.getReferenceName();
        if (!"setUp".equals(methodName)) {
            return;
        }
        PsiExpression target = methodExpression.getQualifierExpression();
        if (!(target instanceof PsiSuperExpression)) {
            return;
        }
        this.callToSuperSetupFound = true;
    }

    public boolean isCallToSuperSetupFound() {
        return this.callToSuperSetupFound;
    }
}

