/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.imports;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaCodeFragment;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.JspPsiUtil;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiImportStatementBase;
import com.intellij.psi.PsiImportStaticStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiPackageStatement;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class StaticImportInspection
extends BaseInspection {
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("static.import.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/imports/StaticImportInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("static.import.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/imports/StaticImportInspection.buildErrorString must not return null");
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new StaticImportVisitor();
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new StaticImportFix();
    }

    private static class StaticImportVisitor
    extends BaseInspectionVisitor {
        private StaticImportVisitor() {
        }

        public void visitClass(@NotNull PsiClass aClass) {
            PsiImportStaticStatement[] importStatements;
            if (aClass == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/imports/StaticImportInspection$StaticImportVisitor.visitClass must not be null");
            }
            if (!(aClass.getParent() instanceof PsiJavaFile)) {
                return;
            }
            if (JspPsiUtil.isInJspFile((PsiElement)aClass.getContainingFile())) {
                return;
            }
            PsiJavaFile file = (PsiJavaFile)aClass.getParent();
            if (file == null) {
                return;
            }
            if (!file.getClasses()[0].equals(aClass)) {
                return;
            }
            PsiImportList importList = file.getImportList();
            if (importList == null) {
                return;
            }
            for (PsiImportStaticStatement importStatement : importStatements = importList.getImportStaticStatements()) {
                this.registerError((PsiElement)importStatement, new Object[0]);
            }
        }
    }

    private static class StaticImportFix
    extends InspectionGadgetsFix {
        private StaticImportFix() {
        }

        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("static.import.replace.quickfix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException("@NotNull method com/siyeh/ig/imports/StaticImportInspection$StaticImportFix.getName must not return null");
            }
            return string;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiImportStaticStatement importStatement = (PsiImportStaticStatement)descriptor.getPsiElement();
            PsiJavaCodeReferenceElement importReference = importStatement.getImportReference();
            if (importReference == null) {
                return;
            }
            JavaResolveResult[] importTargets = importReference.multiResolve(false);
            if (importTargets.length == 0) {
                return;
            }
            boolean onDemand = importStatement.isOnDemand();
            StaticImportReferenceCollector referenceCollector = new StaticImportReferenceCollector(importTargets, onDemand);
            PsiJavaFile file = (PsiJavaFile)importStatement.getContainingFile();
            file.accept((PsiElementVisitor)referenceCollector);
            List<PsiJavaCodeReferenceElement> references = referenceCollector.getReferences();
            HashMap<PsiJavaCodeReferenceElement, PsiMember> referenceTargetMap = new HashMap<PsiJavaCodeReferenceElement, PsiMember>();
            for (PsiJavaCodeReferenceElement psiJavaCodeReferenceElement : references) {
                PsiElement target = psiJavaCodeReferenceElement.resolve();
                if (!(target instanceof PsiMember)) continue;
                PsiMember member = (PsiMember)target;
                referenceTargetMap.put(psiJavaCodeReferenceElement, member);
            }
            importStatement.delete();
            for (Map.Entry entry : referenceTargetMap.entrySet()) {
                StaticImportFix.removeReference((PsiJavaCodeReferenceElement)entry.getKey(), (PsiMember)entry.getValue());
            }
        }

        private static void removeReference(PsiJavaCodeReferenceElement reference, PsiMember target) {
            PsiManager manager = reference.getManager();
            Project project = manager.getProject();
            JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)project);
            PsiElementFactory factory = psiFacade.getElementFactory();
            PsiClass aClass = target.getContainingClass();
            String qualifiedName = aClass.getQualifiedName();
            String text = reference.getText();
            String referenceText = qualifiedName + '.' + text;
            if (reference instanceof PsiReferenceExpression) {
                try {
                    PsiExpression newReference = factory.createExpressionFromText(referenceText, (PsiElement)reference);
                    reference.replace((PsiElement)newReference);
                }
                catch (IncorrectOperationException e) {
                    throw new RuntimeException(e);
                }
            }
            PsiJavaCodeReferenceElement referenceElement = factory.createReferenceElementByFQClassName(referenceText, reference.getResolveScope());
            try {
                reference.replace((PsiElement)referenceElement);
            }
            catch (IncorrectOperationException e) {
                throw new RuntimeException(e);
            }
        }

        static class StaticImportReferenceCollector
        extends JavaRecursiveElementVisitor {
            private final JavaResolveResult[] importTargets;
            private final boolean onDemand;
            private final List<PsiJavaCodeReferenceElement> references;

            StaticImportReferenceCollector(@NotNull JavaResolveResult[] importTargets, boolean onDemand) {
                if (importTargets == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/imports/StaticImportInspection$StaticImportFix$StaticImportReferenceCollector.<init> must not be null");
                }
                this.references = new ArrayList<PsiJavaCodeReferenceElement>();
                this.importTargets = importTargets;
                this.onDemand = onDemand;
            }

            public void visitReferenceElement(PsiJavaCodeReferenceElement reference) {
                super.visitReferenceElement(reference);
                if (StaticImportReferenceCollector.isFullyQualifiedReference(reference)) {
                    return;
                }
                PsiElement parent = reference.getParent();
                if (parent instanceof PsiImportStatementBase) {
                    return;
                }
                while (parent instanceof PsiJavaCodeReferenceElement) {
                    if (!((parent = parent.getParent()) instanceof PsiImportStatementBase)) continue;
                    return;
                }
                this.checkStaticImportReference(reference);
            }

            private void checkStaticImportReference(PsiJavaCodeReferenceElement reference) {
                if (reference.isQualified()) {
                    return;
                }
                PsiElement target = reference.resolve();
                if (!(target instanceof PsiMethod || target instanceof PsiClass || target instanceof PsiField)) {
                    return;
                }
                PsiMember member = (PsiMember)target;
                for (JavaResolveResult importTarget : this.importTargets) {
                    PsiElement targetElement = importTarget.getElement();
                    if (targetElement instanceof PsiMethod) {
                        if (!member.equals(targetElement)) continue;
                        this.addReference(reference);
                        continue;
                    }
                    if (!(targetElement instanceof PsiClass)) continue;
                    if (this.onDemand) {
                        PsiClass containingClass = member.getContainingClass();
                        if (!InheritanceUtil.isInheritorOrSelf((PsiClass)((PsiClass)targetElement), (PsiClass)containingClass, (boolean)true)) continue;
                        this.addReference(reference);
                        continue;
                    }
                    if (!targetElement.equals(member)) continue;
                    this.addReference(reference);
                }
            }

            private void addReference(PsiJavaCodeReferenceElement reference) {
                this.references.add(reference);
            }

            public List<PsiJavaCodeReferenceElement> getReferences() {
                return this.references;
            }

            public static boolean isFullyQualifiedReference(PsiJavaCodeReferenceElement reference) {
                if (!reference.isQualified()) {
                    return false;
                }
                PsiElement directParent = reference.getParent();
                if (directParent instanceof PsiMethodCallExpression || directParent instanceof PsiAssignmentExpression || directParent instanceof PsiVariable) {
                    return false;
                }
                PsiElement parent = PsiTreeUtil.getParentOfType((PsiElement)reference, (Class[])new Class[]{PsiImportStatementBase.class, PsiPackageStatement.class, JavaCodeFragment.class});
                if (parent != null) {
                    return false;
                }
                PsiElement target = reference.resolve();
                if (!(target instanceof PsiClass)) {
                    return false;
                }
                PsiClass aClass = (PsiClass)target;
                String fqName = aClass.getQualifiedName();
                if (fqName == null) {
                    return false;
                }
                String text = StringUtils.stripAngleBrackets(reference.getText());
                return text.equals(fqName);
            }
        }
    }
}

