/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.errorhandling;

import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ExceptionUtils;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class CatchGenericClassInspection
extends BaseInspection {
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("catch.generic.class.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/errorhandling/CatchGenericClassInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("catch.generic.class.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/errorhandling/CatchGenericClassInspection.buildErrorString must not return null");
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new CatchGenericClassVisitor();
    }

    private static class CatchGenericClassVisitor
    extends BaseInspectionVisitor {
        private CatchGenericClassVisitor() {
        }

        public void visitTryStatement(@NotNull PsiTryStatement statement) {
            PsiParameter[] parameters;
            if (statement == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/errorhandling/CatchGenericClassInspection$CatchGenericClassVisitor.visitTryStatement must not be null");
            }
            super.visitTryStatement(statement);
            PsiCodeBlock tryBlock = statement.getTryBlock();
            if (tryBlock == null) {
                return;
            }
            Set<PsiType> exceptionsThrown = ExceptionUtils.calculateExceptionsThrown((PsiElement)tryBlock);
            for (PsiParameter parameter : parameters = statement.getCatchBlockParameters()) {
                this.checkParameter(parameter, exceptionsThrown);
            }
        }

        private void checkParameter(PsiParameter parameter, Set<PsiType> exceptionsThrown) {
            PsiType type = parameter.getType();
            if (!ExceptionUtils.isGenericExceptionClass(type)) {
                return;
            }
            if (exceptionsThrown.contains(type)) {
                return;
            }
            PsiTypeElement typeElement = parameter.getTypeElement();
            this.registerError((PsiElement)typeElement, new Object[0]);
        }
    }
}

