/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.dataflow;

import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.dataflow.VariableUsedInInnerClassVisitor;
import com.siyeh.ig.fixes.InlineVariableFix;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import com.siyeh.ig.ui.MultipleCheckboxOptionsPanel;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class UnnecessaryLocalVariableInspection
extends BaseInspection {
    public boolean m_ignoreImmediatelyReturnedVariables = false;
    public boolean m_ignoreAnnotatedVariables = false;

    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("redundant.local.variable.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/dataflow/UnnecessaryLocalVariableInspection.getDisplayName must not return null");
        }
        return string;
    }

    public JComponent createOptionsPanel() {
        MultipleCheckboxOptionsPanel optionsPanel = new MultipleCheckboxOptionsPanel(this);
        optionsPanel.addCheckbox(InspectionGadgetsBundle.message("redundant.local.variable.ignore.option", new Object[0]), "m_ignoreImmediatelyReturnedVariables");
        optionsPanel.addCheckbox(InspectionGadgetsBundle.message("redundant.local.variable.annotation.option", new Object[0]), "m_ignoreAnnotatedVariables");
        return optionsPanel;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("unnecessary.local.variable.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/dataflow/UnnecessaryLocalVariableInspection.buildErrorString must not return null");
        }
        return string;
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new InlineVariableFix();
    }

    @Override
    protected boolean buildQuickFixesOnlyForOnTheFlyErrors() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new UnnecessaryLocalVariableVisitor();
    }

    private class UnnecessaryLocalVariableVisitor
    extends BaseInspectionVisitor {
        private UnnecessaryLocalVariableVisitor() {
        }

        public void visitLocalVariable(@NotNull PsiLocalVariable variable) {
            PsiModifierList list;
            if (variable == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/dataflow/UnnecessaryLocalVariableInspection$UnnecessaryLocalVariableVisitor.visitLocalVariable must not be null");
            }
            super.visitLocalVariable(variable);
            if (UnnecessaryLocalVariableInspection.this.m_ignoreAnnotatedVariables && (list = variable.getModifierList()) != null && list.getAnnotations().length > 0) {
                return;
            }
            if (this.isCopyVariable((PsiVariable)variable)) {
                this.registerVariableError((PsiVariable)variable, new Object[0]);
            } else if (!UnnecessaryLocalVariableInspection.this.m_ignoreImmediatelyReturnedVariables && this.isImmediatelyReturned((PsiVariable)variable)) {
                this.registerVariableError((PsiVariable)variable, new Object[0]);
            } else if (!UnnecessaryLocalVariableInspection.this.m_ignoreImmediatelyReturnedVariables && this.isImmediatelyThrown((PsiVariable)variable)) {
                this.registerVariableError((PsiVariable)variable, new Object[0]);
            } else if (this.isImmediatelyAssigned((PsiVariable)variable)) {
                this.registerVariableError((PsiVariable)variable, new Object[0]);
            } else if (this.isImmediatelyAssignedAsDeclaration((PsiVariable)variable)) {
                this.registerVariableError((PsiVariable)variable, new Object[0]);
            }
        }

        private boolean isCopyVariable(PsiVariable variable) {
            PsiExpression initializer = variable.getInitializer();
            if (!(initializer instanceof PsiReferenceExpression)) {
                return false;
            }
            PsiReferenceExpression reference = (PsiReferenceExpression)initializer;
            PsiElement referent = reference.resolve();
            if (referent == null) {
                return false;
            }
            if (!(referent instanceof PsiLocalVariable) && !(referent instanceof PsiParameter)) {
                return false;
            }
            PsiCodeBlock containingScope = (PsiCodeBlock)PsiTreeUtil.getParentOfType((PsiElement)variable, PsiCodeBlock.class);
            if (containingScope == null) {
                return false;
            }
            if (!variable.hasModifierProperty("final") && VariableAccessUtils.variableIsAssigned(variable, (PsiElement)containingScope, false)) {
                return false;
            }
            PsiVariable initialization = (PsiVariable)referent;
            if (!initialization.hasModifierProperty("final") && VariableAccessUtils.variableIsAssigned(initialization, (PsiElement)containingScope, false)) {
                return false;
            }
            return initialization.hasModifierProperty("final") || !variable.hasModifierProperty("final") || !this.variableIsUsedInInnerClass(containingScope, variable);
        }

        private boolean isImmediatelyReturned(PsiVariable variable) {
            PsiCodeBlock containingScope = (PsiCodeBlock)PsiTreeUtil.getParentOfType((PsiElement)variable, PsiCodeBlock.class);
            if (containingScope == null) {
                return false;
            }
            PsiDeclarationStatement declarationStatement = (PsiDeclarationStatement)PsiTreeUtil.getParentOfType((PsiElement)variable, PsiDeclarationStatement.class);
            if (declarationStatement == null) {
                return false;
            }
            PsiStatement nextStatement = null;
            PsiStatement[] statements = containingScope.getStatements();
            for (int i = 0; i < statements.length - 1; ++i) {
                if (!statements[i].equals(declarationStatement)) continue;
                nextStatement = statements[i + 1];
            }
            if (nextStatement == null) {
                return false;
            }
            if (!(nextStatement instanceof PsiReturnStatement)) {
                return false;
            }
            PsiReturnStatement returnStatement = (PsiReturnStatement)nextStatement;
            PsiExpression returnValue = returnStatement.getReturnValue();
            if (returnValue == null) {
                return false;
            }
            if (!(returnValue instanceof PsiReferenceExpression)) {
                return false;
            }
            PsiElement referent = ((PsiReference)returnValue).resolve();
            return referent != null && referent.equals(variable);
        }

        private boolean isImmediatelyThrown(PsiVariable variable) {
            PsiCodeBlock containingScope = (PsiCodeBlock)PsiTreeUtil.getParentOfType((PsiElement)variable, PsiCodeBlock.class);
            if (containingScope == null) {
                return false;
            }
            PsiDeclarationStatement declarationStatement = (PsiDeclarationStatement)PsiTreeUtil.getParentOfType((PsiElement)variable, PsiDeclarationStatement.class);
            if (declarationStatement == null) {
                return false;
            }
            PsiStatement nextStatement = null;
            PsiStatement[] statements = containingScope.getStatements();
            for (int i = 0; i < statements.length - 1; ++i) {
                if (!statements[i].equals(declarationStatement)) continue;
                nextStatement = statements[i + 1];
            }
            if (nextStatement == null) {
                return false;
            }
            if (!(nextStatement instanceof PsiThrowStatement)) {
                return false;
            }
            PsiThrowStatement throwStatement = (PsiThrowStatement)nextStatement;
            PsiExpression returnValue = throwStatement.getException();
            if (returnValue == null) {
                return false;
            }
            if (!(returnValue instanceof PsiReferenceExpression)) {
                return false;
            }
            PsiElement referent = ((PsiReference)returnValue).resolve();
            return referent != null && referent.equals(variable);
        }

        private boolean isImmediatelyAssigned(PsiVariable variable) {
            PsiCodeBlock containingScope = (PsiCodeBlock)PsiTreeUtil.getParentOfType((PsiElement)variable, PsiCodeBlock.class);
            if (containingScope == null) {
                return false;
            }
            PsiDeclarationStatement declarationStatement = (PsiDeclarationStatement)PsiTreeUtil.getParentOfType((PsiElement)variable, PsiDeclarationStatement.class);
            if (declarationStatement == null) {
                return false;
            }
            PsiStatement nextStatement = null;
            int followingStatementNumber = 0;
            PsiStatement[] statements = containingScope.getStatements();
            for (int i = 0; i < statements.length - 1; ++i) {
                if (!statements[i].equals(declarationStatement)) continue;
                nextStatement = statements[i + 1];
                followingStatementNumber = i + 2;
            }
            if (nextStatement == null) {
                return false;
            }
            if (!(nextStatement instanceof PsiExpressionStatement)) {
                return false;
            }
            PsiExpressionStatement expressionStatement = (PsiExpressionStatement)nextStatement;
            PsiExpression expression = expressionStatement.getExpression();
            if (!(expression instanceof PsiAssignmentExpression)) {
                return false;
            }
            PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)expression;
            IElementType tokenType = assignmentExpression.getOperationTokenType();
            if (tokenType != JavaTokenType.EQ) {
                return false;
            }
            PsiExpression rhs = assignmentExpression.getRExpression();
            if (rhs == null) {
                return false;
            }
            if (!(rhs instanceof PsiReferenceExpression)) {
                return false;
            }
            PsiReferenceExpression reference = (PsiReferenceExpression)rhs;
            PsiElement referent = reference.resolve();
            if (referent == null || !referent.equals(variable)) {
                return false;
            }
            PsiExpression lhs = assignmentExpression.getLExpression();
            if (lhs instanceof PsiArrayAccessExpression) {
                return false;
            }
            if (VariableAccessUtils.variableIsUsed(variable, (PsiElement)lhs)) {
                return false;
            }
            for (int i = followingStatementNumber; i < statements.length; ++i) {
                if (!VariableAccessUtils.variableIsUsed(variable, (PsiElement)statements[i])) continue;
                return false;
            }
            return true;
        }

        private boolean isImmediatelyAssignedAsDeclaration(PsiVariable variable) {
            PsiCodeBlock containingScope = (PsiCodeBlock)PsiTreeUtil.getParentOfType((PsiElement)variable, PsiCodeBlock.class);
            if (containingScope == null) {
                return false;
            }
            PsiDeclarationStatement declarationStatement = (PsiDeclarationStatement)PsiTreeUtil.getParentOfType((PsiElement)variable, PsiDeclarationStatement.class);
            if (declarationStatement == null) {
                return false;
            }
            PsiStatement nextStatement = null;
            int followingStatementNumber = 0;
            PsiStatement[] statements = containingScope.getStatements();
            for (int i = 0; i < statements.length - 1; ++i) {
                if (!statements[i].equals(declarationStatement)) continue;
                nextStatement = statements[i + 1];
                followingStatementNumber = i + 2;
            }
            if (nextStatement == null) {
                return false;
            }
            if (!(nextStatement instanceof PsiDeclarationStatement)) {
                return false;
            }
            PsiDeclarationStatement declaration = (PsiDeclarationStatement)nextStatement;
            PsiElement[] declarations = declaration.getDeclaredElements();
            if (declarations.length != 1) {
                return false;
            }
            if (!(declarations[0] instanceof PsiVariable)) {
                return false;
            }
            PsiExpression rhs = ((PsiVariable)declarations[0]).getInitializer();
            if (rhs == null) {
                return false;
            }
            if (!(rhs instanceof PsiReferenceExpression)) {
                return false;
            }
            PsiElement referent = ((PsiReference)rhs).resolve();
            if (referent == null || !referent.equals(variable)) {
                return false;
            }
            for (int i = followingStatementNumber; i < statements.length; ++i) {
                if (!VariableAccessUtils.variableIsUsed(variable, (PsiElement)statements[i])) continue;
                return false;
            }
            return true;
        }

        private boolean variableIsUsedInInnerClass(PsiCodeBlock block, PsiVariable variable) {
            VariableUsedInInnerClassVisitor visitor = new VariableUsedInInnerClassVisitor(variable);
            block.accept((PsiElementVisitor)visitor);
            return visitor.isUsedInInnerClass();
        }
    }
}

