/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.controlflow;

import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiBreakStatement;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import org.jetbrains.annotations.NotNull;

public class BreakStatementInspection
extends BaseInspection {
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("break.statement.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/controlflow/BreakStatementInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("statement.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/controlflow/BreakStatementInspection.buildErrorString must not return null");
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new BreakStatementVisitor();
    }

    private static class BreakStatementVisitor
    extends BaseInspectionVisitor {
        private BreakStatementVisitor() {
        }

        public void visitBreakStatement(@NotNull PsiBreakStatement statement) {
            if (statement == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/controlflow/BreakStatementInspection$BreakStatementVisitor.visitBreakStatement must not be null");
            }
            super.visitBreakStatement(statement);
            PsiSwitchStatement switchStatement = (PsiSwitchStatement)PsiTreeUtil.getParentOfType((PsiElement)statement, PsiSwitchStatement.class);
            if (switchStatement != null && BreakStatementVisitor.isTopLevelBreakInSwitch(statement)) {
                return;
            }
            this.registerStatementError((PsiStatement)statement, new Object[0]);
        }

        private static boolean isTopLevelBreakInSwitch(PsiBreakStatement statement) {
            PsiElement parent = statement.getParent();
            if (!(parent instanceof PsiCodeBlock)) {
                return false;
            }
            PsiElement parentsParent = parent.getParent();
            if (parentsParent instanceof PsiSwitchStatement) {
                return true;
            }
            if (!(parentsParent instanceof PsiBlockStatement)) {
                return false;
            }
            PsiElement blocksParent = parentsParent.getParent();
            if (!(blocksParent instanceof PsiCodeBlock)) {
                return false;
            }
            PsiElement blocksParentsParent = blocksParent.getParent();
            return blocksParentsParent instanceof PsiSwitchStatement;
        }
    }
}

