/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.classlayout;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClassMayBeInterfaceInspection
extends BaseInspection {
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("class.may.be.interface.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/classlayout/ClassMayBeInterfaceInspection.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("class.may.be.interface.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/siyeh/ig/classlayout/ClassMayBeInterfaceInspection.buildErrorString must not return null");
        }
        return string;
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new ClassMayBeInterfaceFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ClassMayBeInterfaceVisitor();
    }

    private static class ClassMayBeInterfaceVisitor
    extends BaseInspectionVisitor {
        private ClassMayBeInterfaceVisitor() {
        }

        public void visitClass(@NotNull PsiClass aClass) {
            if (aClass == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/classlayout/ClassMayBeInterfaceInspection$ClassMayBeInterfaceVisitor.visitClass must not be null");
            }
            if (aClass.isInterface() || aClass.isAnnotationType() || aClass.isEnum()) {
                return;
            }
            if (aClass instanceof PsiTypeParameter || aClass instanceof PsiAnonymousClass) {
                return;
            }
            if (!ClassMayBeInterfaceVisitor.mayBeInterface(aClass)) {
                return;
            }
            this.registerClassError(aClass, new Object[0]);
        }

        public static boolean mayBeInterface(PsiClass aClass) {
            PsiJavaCodeReferenceElement[] extendsElements;
            PsiReferenceList extendsList = aClass.getExtendsList();
            if (extendsList != null && (extendsElements = extendsList.getReferenceElements()).length > 0) {
                return false;
            }
            PsiClassInitializer[] initializers = aClass.getInitializers();
            if (initializers.length > 0) {
                return false;
            }
            if (!ClassMayBeInterfaceVisitor.allMethodsPublicAbstract(aClass)) {
                return false;
            }
            if (!ClassMayBeInterfaceVisitor.allFieldsPublicStaticFinal(aClass)) {
                return false;
            }
            return ClassMayBeInterfaceVisitor.allInnerClassesPublic(aClass);
        }

        private static boolean allFieldsPublicStaticFinal(PsiClass aClass) {
            PsiField[] fields;
            boolean allFieldsStaticFinal = true;
            for (PsiField field : fields = aClass.getFields()) {
                if (field.hasModifierProperty("static") && field.hasModifierProperty("final") && field.hasModifierProperty("public")) continue;
                allFieldsStaticFinal = false;
            }
            return allFieldsStaticFinal;
        }

        private static boolean allMethodsPublicAbstract(PsiClass aClass) {
            PsiMethod[] methods;
            for (PsiMethod method : methods = aClass.getMethods()) {
                if (method.hasModifierProperty("abstract") && method.hasModifierProperty("public")) continue;
                return false;
            }
            return true;
        }

        private static boolean allInnerClassesPublic(PsiClass aClass) {
            PsiClass[] innerClasses;
            for (PsiClass innerClass : innerClasses = aClass.getInnerClasses()) {
                if (innerClass.hasModifierProperty("public")) continue;
                return false;
            }
            return true;
        }
    }

    private static class ClassMayBeInterfaceFix
    extends InspectionGadgetsFix {
        private ClassMayBeInterfaceFix() {
        }

        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("class.may.be.interface.convert.quickfix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException("@NotNull method com/siyeh/ig/classlayout/ClassMayBeInterfaceInspection$ClassMayBeInterfaceFix.getName must not return null");
            }
            return string;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiIdentifier classNameIdentifier = (PsiIdentifier)descriptor.getPsiElement();
            PsiClass interfaceClass = (PsiClass)classNameIdentifier.getParent();
            ClassMayBeInterfaceFix.moveSubClassExtendsToImplements(interfaceClass);
            ClassMayBeInterfaceFix.changeClassToInterface(interfaceClass);
            ClassMayBeInterfaceFix.moveImplementsToExtends(interfaceClass);
        }

        private static void changeClassToInterface(PsiClass aClass) throws IncorrectOperationException {
            PsiIdentifier nameIdentifier = aClass.getNameIdentifier();
            if (nameIdentifier == null) {
                return;
            }
            PsiKeyword classKeyword = (PsiKeyword)PsiTreeUtil.getPrevSiblingOfType((PsiElement)nameIdentifier, PsiKeyword.class);
            PsiManager manager = aClass.getManager();
            PsiElementFactory factory = JavaPsiFacade.getInstance((Project)manager.getProject()).getElementFactory();
            PsiKeyword interfaceKeyword = factory.createKeyword("interface");
            if (classKeyword == null) {
                return;
            }
            PsiModifierList modifierList = aClass.getModifierList();
            if (modifierList != null) {
                modifierList.setModifierProperty("abstract", false);
                modifierList.setModifierProperty("final", false);
            }
            classKeyword.replace((PsiElement)interfaceKeyword);
        }

        private static void moveImplementsToExtends(PsiClass anInterface) throws IncorrectOperationException {
            PsiJavaCodeReferenceElement[] referenceElements;
            PsiReferenceList extendsList = anInterface.getExtendsList();
            if (extendsList == null) {
                return;
            }
            PsiReferenceList implementsList = anInterface.getImplementsList();
            if (implementsList == null) {
                return;
            }
            for (PsiJavaCodeReferenceElement referenceElement : referenceElements = implementsList.getReferenceElements()) {
                extendsList.add((PsiElement)referenceElement);
                referenceElement.delete();
            }
        }

        private static void moveSubClassExtendsToImplements(PsiClass oldClass) throws IncorrectOperationException {
            PsiElementFactory elementFactory = JavaPsiFacade.getInstance((Project)oldClass.getProject()).getElementFactory();
            PsiJavaCodeReferenceElement classReference = elementFactory.createClassReferenceElement(oldClass);
            SearchScope searchScope = oldClass.getUseScope();
            for (PsiClass inheritor : ClassInheritorsSearch.search((PsiClass)oldClass, (SearchScope)searchScope, (boolean)false)) {
                PsiReferenceList extendsList = inheritor.getExtendsList();
                if (extendsList == null) continue;
                PsiReferenceList implementsList = inheritor.getImplementsList();
                ClassMayBeInterfaceFix.moveReference(extendsList, implementsList, classReference);
            }
        }

        private static void moveReference(@NotNull PsiReferenceList source, @Nullable PsiReferenceList target, @NotNull PsiJavaCodeReferenceElement reference) throws IncorrectOperationException {
            if (source == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/siyeh/ig/classlayout/ClassMayBeInterfaceInspection$ClassMayBeInterfaceFix.moveReference must not be null");
            }
            if (reference == null) {
                throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/siyeh/ig/classlayout/ClassMayBeInterfaceInspection$ClassMayBeInterfaceFix.moveReference must not be null");
            }
            PsiJavaCodeReferenceElement[] sourceReferences = source.getReferenceElements();
            String fqName = reference.getQualifiedName();
            for (PsiJavaCodeReferenceElement sourceReference : sourceReferences) {
                String implementsReferenceFqName = sourceReference.getQualifiedName();
                if (!fqName.equals(implementsReferenceFqName)) continue;
                if (target != null) {
                    target.add((PsiElement)sourceReference);
                }
                sourceReference.delete();
            }
        }
    }
}

