/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.wizard;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.IconLoader;
import com.intellij.ui.ColoredTableCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.uiDesigner.lw.LwComponent;
import com.intellij.uiDesigner.palette.ComponentItem;
import com.intellij.uiDesigner.palette.Palette;
import com.intellij.uiDesigner.wizard.FormProperty;
import java.awt.Color;
import javax.swing.Icon;
import javax.swing.JTable;
import org.jetbrains.annotations.NotNull;

final class FormPropertyTableCellRenderer
extends ColoredTableCellRenderer {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.uiDesigner.wizard.FormPropertyTableCellRenderer");
    private final Palette myPalette;
    private final SimpleTextAttributes myAttrs1;
    private final SimpleTextAttributes myAttrs2;
    private final SimpleTextAttributes myAttrs3;

    FormPropertyTableCellRenderer(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/uiDesigner/wizard/FormPropertyTableCellRenderer.<init> must not be null");
        }
        this.myPalette = Palette.getInstance(project);
        this.myAttrs1 = SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES;
        this.myAttrs2 = SimpleTextAttributes.REGULAR_ATTRIBUTES;
        this.myAttrs3 = new SimpleTextAttributes(0, Color.GRAY);
        this.setFocusBorderAroundIcon(true);
    }

    protected void customizeCellRenderer(JTable table, @NotNull Object value, boolean selected, boolean hasFocus, int row, int column) {
        String packageName;
        String shortClassName;
        if (value == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/uiDesigner/wizard/FormPropertyTableCellRenderer.customizeCellRenderer must not be null");
        }
        FormProperty property = (FormProperty)value;
        LwComponent component = property.getLwComponent();
        String fqClassName = component.getComponentClassName();
        ComponentItem item = this.myPalette.getItem(fqClassName);
        Icon icon = item != null ? item.getSmallIcon() : IconLoader.getIcon((String)"/com/intellij/uiDesigner/icons/unknown-small.png");
        this.setIcon(icon);
        this.append(component.getBinding(), this.myAttrs1);
        int lastDotIndex = fqClassName.lastIndexOf(46);
        if (lastDotIndex != -1) {
            shortClassName = fqClassName.substring(lastDotIndex + 1);
            packageName = fqClassName.substring(0, lastDotIndex);
        } else {
            shortClassName = fqClassName;
            packageName = null;
        }
        LOG.assertTrue(shortClassName.length() > 0);
        this.append(" ", this.myAttrs2);
        this.append(shortClassName, this.myAttrs2);
        if (packageName != null) {
            this.append(" (", this.myAttrs3);
            this.append(packageName, this.myAttrs3);
            this.append(")", this.myAttrs3);
        }
    }
}

