/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.radComponents;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.Comparing;
import com.intellij.uiDesigner.FormEditingUtil;
import com.intellij.uiDesigner.XmlWriter;
import com.intellij.uiDesigner.lw.IButtonGroup;
import com.intellij.uiDesigner.lw.IComponent;
import com.intellij.uiDesigner.lw.IRootContainer;
import com.intellij.uiDesigner.lw.LwInspectionSuppression;
import com.intellij.uiDesigner.radComponents.RadButtonGroup;
import com.intellij.uiDesigner.radComponents.RadComponent;
import com.intellij.uiDesigner.radComponents.RadContainer;
import com.intellij.uiDesigner.radComponents.RadLayoutManager;
import com.intellij.uiDesigner.radComponents.RadXYLayoutManager;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class RadRootContainer
extends RadContainer
implements IRootContainer {
    private String myClassToBind;
    private String myMainComponentBinding;
    private Locale myStringDescriptorLocale;
    private final List<RadButtonGroup> myButtonGroups = new ArrayList<RadButtonGroup>();
    private final List<LwInspectionSuppression> myInspectionSuppressions = new ArrayList<LwInspectionSuppression>();

    public RadRootContainer(Module module, String id) {
        super(module, JPanel.class, id);
        this.getDelegee().setBackground(Color.WHITE);
    }

    @Override
    public boolean isSelected() {
        return false;
    }

    @Override
    public void setSelected(boolean ignored) {
    }

    @Nullable
    public String getClassToBind() {
        return this.myClassToBind;
    }

    public void setClassToBind(String classToBind) {
        this.myClassToBind = classToBind;
    }

    public String getMainComponentBinding() {
        return this.myMainComponentBinding;
    }

    public void setMainComponentBinding(String mainComponentBinding) {
        this.myMainComponentBinding = mainComponentBinding;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(XmlWriter writer) {
        writer.startElement("form", "http://www.intellij.com/uidesigner/form/");
        try {
            String mainComponentBinding;
            writer.addAttribute("version", 1);
            String classToBind = this.getClassToBind();
            if (classToBind != null) {
                writer.addAttribute("bind-to-class", classToBind);
            }
            if ((mainComponentBinding = this.getMainComponentBinding()) != null) {
                writer.addAttribute("stored-main-component-binding", mainComponentBinding);
            }
            this.writeChildrenImpl(writer);
            if (this.myButtonGroups.size() > 0) {
                writer.startElement("buttonGroups");
                for (RadButtonGroup group : this.myButtonGroups) {
                    group.write(writer);
                }
                writer.endElement();
            }
            this.writeInspectionSuppressions(writer);
        }
        finally {
            writer.endElement();
        }
    }

    private void writeInspectionSuppressions(XmlWriter writer) {
        if (this.myInspectionSuppressions.size() > 0) {
            writer.startElement("inspectionSuppressions");
            for (LwInspectionSuppression suppression : this.myInspectionSuppressions) {
                writer.startElement("suppress");
                writer.addAttribute("inspection", suppression.getInspectionId());
                if (suppression.getComponentId() != null) {
                    writer.addAttribute("id", suppression.getComponentId());
                }
                writer.endElement();
            }
            writer.endElement();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeConstraints(XmlWriter writer) {
        writer.startElement("constraints");
        try {
            this.myLayoutManager.writeChildConstraints(writer, this);
        }
        finally {
            writer.endElement();
        }
    }

    @Override
    @Nullable
    protected RadLayoutManager createInitialLayoutManager() {
        return RadXYLayoutManager.INSTANCE;
    }

    public void setGroupForComponent(@NotNull RadComponent component, @Nullable RadButtonGroup value) {
        if (component == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/uiDesigner/radComponents/RadRootContainer.setGroupForComponent must not be null");
        }
        for (int i = this.myButtonGroups.size() - 1; i >= 0; --i) {
            RadButtonGroup group = this.myButtonGroups.get(i);
            if (group == value) {
                group.add(component);
                continue;
            }
            group.remove(component);
            if (!group.isEmpty()) continue;
            this.myButtonGroups.remove(i);
        }
    }

    public RadButtonGroup[] getButtonGroups() {
        return this.myButtonGroups.toArray(new RadButtonGroup[this.myButtonGroups.size()]);
    }

    public String suggestGroupName() {
        String suggestedName;
        int groupNumber = 1;
        block0: while (true) {
            suggestedName = "buttonGroup" + groupNumber;
            for (RadButtonGroup group : this.myButtonGroups) {
                if (!group.getName().equals(suggestedName)) continue;
                ++groupNumber;
                continue block0;
            }
            break;
        }
        return suggestedName;
    }

    public RadButtonGroup createGroup(String groupName) {
        RadButtonGroup group = new RadButtonGroup(groupName);
        this.myButtonGroups.add(group);
        return group;
    }

    public void deleteGroup(RadButtonGroup group) {
        this.myButtonGroups.remove(group);
    }

    public void setButtonGroups(IButtonGroup[] buttonGroups) {
        this.myButtonGroups.clear();
        for (IButtonGroup lwGroup : buttonGroups) {
            String[] componentIds = lwGroup.getComponentIds();
            if (componentIds.length <= 0) continue;
            RadButtonGroup group = this.createGroup(lwGroup.getName());
            group.setBound(lwGroup.isBound());
            group.addComponentIds(componentIds);
        }
    }

    public List<RadComponent> getGroupContents(RadButtonGroup group) {
        ArrayList<RadComponent> result = new ArrayList<RadComponent>();
        for (String id : group.getComponentIds()) {
            RadComponent component = (RadComponent)FormEditingUtil.findComponent(this, id);
            if (component == null) continue;
            result.add(component);
        }
        return result;
    }

    public String getButtonGroupName(IComponent component) {
        for (RadButtonGroup group : this.myButtonGroups) {
            if (!group.contains((RadComponent)component)) continue;
            return group.getName();
        }
        return null;
    }

    public String[] getButtonGroupComponentIds(String groupName) {
        for (RadButtonGroup group : this.myButtonGroups) {
            if (!group.getName().equals(groupName)) continue;
            return group.getComponentIds();
        }
        throw new IllegalArgumentException("Cannot find group " + groupName);
    }

    public Locale getStringDescriptorLocale() {
        return this.myStringDescriptorLocale;
    }

    public void setStringDescriptorLocale(Locale stringDescriptorLocale) {
        this.myStringDescriptorLocale = stringDescriptorLocale;
    }

    public void suppressInspection(String inspectionId, @Nullable RadComponent component) {
        for (int i = this.myInspectionSuppressions.size() - 1; i >= 0; --i) {
            LwInspectionSuppression suppression = this.myInspectionSuppressions.get(i);
            if (!suppression.getInspectionId().equals(inspectionId)) continue;
            if (component != null && (component.getId().equals(suppression.getComponentId()) || suppression.getComponentId() == null)) {
                return;
            }
            if (component != null || suppression.getComponentId() == null) continue;
            this.myInspectionSuppressions.remove(i);
        }
        this.myInspectionSuppressions.add(new LwInspectionSuppression(inspectionId, component == null ? null : component.getId()));
    }

    public boolean isInspectionSuppressed(String inspectionId, String componentId) {
        for (LwInspectionSuppression suppression : this.myInspectionSuppressions) {
            if (suppression.getComponentId() != null && !suppression.getComponentId().equals(componentId) || !suppression.getInspectionId().equals(inspectionId)) continue;
            return true;
        }
        return false;
    }

    public LwInspectionSuppression[] getInspectionSuppressions() {
        return this.myInspectionSuppressions.toArray(new LwInspectionSuppression[this.myInspectionSuppressions.size()]);
    }

    public void setInspectionSuppressions(LwInspectionSuppression[] inspectionSuppressions) {
        this.myInspectionSuppressions.clear();
        Collections.addAll(this.myInspectionSuppressions, inspectionSuppressions);
    }

    public void removeInspectionSuppression(LwInspectionSuppression suppression) {
        for (LwInspectionSuppression existing : this.myInspectionSuppressions) {
            if (!existing.getInspectionId().equals(suppression.getInspectionId()) || !Comparing.equal((String)existing.getComponentId(), (String)suppression.getComponentId())) continue;
            this.myInspectionSuppressions.remove(existing);
            break;
        }
    }
}

