/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.propertyInspector.properties;

import com.intellij.uiDesigner.FormEditingUtil;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.propertyInspector.Property;
import com.intellij.uiDesigner.propertyInspector.PropertyEditor;
import com.intellij.uiDesigner.propertyInspector.PropertyRenderer;
import com.intellij.uiDesigner.propertyInspector.editors.IntRegexEditor;
import com.intellij.uiDesigner.propertyInspector.properties.IntFieldProperty;
import com.intellij.uiDesigner.propertyInspector.renderers.DimensionRenderer;
import com.intellij.uiDesigner.radComponents.RadComponent;
import java.awt.Dimension;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractDimensionProperty<T extends RadComponent>
extends Property<T, Dimension> {
    private final Property[] myChildren = new Property[]{new IntFieldProperty(this, "width", -1, new Dimension(0, 0)), new IntFieldProperty(this, "height", -1, new Dimension(0, 0))};
    private final DimensionRenderer myRenderer = new DimensionRenderer();
    private final IntRegexEditor<Dimension> myEditor = new IntRegexEditor<Dimension>(Dimension.class, this.myRenderer, new int[]{-1, -1});

    public AbstractDimensionProperty(@NonNls String name) {
        super(null, name);
    }

    @Override
    @NotNull
    public final Property[] getChildren(RadComponent component) {
        if (this.myChildren == null) {
            throw new IllegalStateException("@NotNull method com/intellij/uiDesigner/propertyInspector/properties/AbstractDimensionProperty.getChildren must not return null");
        }
        return this.myChildren;
    }

    @Override
    @NotNull
    public final PropertyRenderer<Dimension> getRenderer() {
        DimensionRenderer dimensionRenderer = this.myRenderer;
        if (dimensionRenderer == null) {
            throw new IllegalStateException("@NotNull method com/intellij/uiDesigner/propertyInspector/properties/AbstractDimensionProperty.getRenderer must not return null");
        }
        return dimensionRenderer;
    }

    @Override
    public final PropertyEditor<Dimension> getEditor() {
        return this.myEditor;
    }

    @Override
    public Dimension getValue(T component) {
        return this.getValueImpl(((RadComponent)component).getConstraints());
    }

    protected abstract Dimension getValueImpl(GridConstraints var1);

    @Override
    public boolean isModified(T component) {
        Dimension defaultValue = this.getValueImpl(FormEditingUtil.getDefaultConstraints(component));
        return !this.getValueImpl(((RadComponent)component).getConstraints()).equals(defaultValue);
    }

    @Override
    public void resetValue(T component) throws Exception {
        this.setValueImpl(component, this.getValueImpl(FormEditingUtil.getDefaultConstraints(component)));
    }
}

