/*
 * Decompiled with CFR 0.152.
 */
package com.theoryinpractice.testng.inspection;

import com.intellij.codeInspection.BaseJavaLocalInspectionTool;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiNonJavaFileReferenceProcessor;
import com.intellij.psi.util.PsiClassUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.IncorrectOperationException;
import com.theoryinpractice.testng.configuration.browser.SuiteBrowser;
import com.theoryinpractice.testng.util.TestNGUtil;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UndeclaredTestInspection
extends BaseJavaLocalInspectionTool {
    private static final Logger LOG = Logger.getInstance((String)("#" + UndeclaredTestInspection.class.getName()));

    @Nls
    @NotNull
    public String getGroupDisplayName() {
        if ("TestNG" == null) {
            throw new IllegalStateException("@NotNull method com/theoryinpractice/testng/inspection/UndeclaredTestInspection.getGroupDisplayName must not return null");
        }
        return "TestNG";
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        if ("Undeclared test" == null) {
            throw new IllegalStateException("@NotNull method com/theoryinpractice/testng/inspection/UndeclaredTestInspection.getDisplayName must not return null");
        }
        return "Undeclared test";
    }

    @NonNls
    @NotNull
    public String getShortName() {
        if ("UndeclaredTests" == null) {
            throw new IllegalStateException("@NotNull method com/theoryinpractice/testng/inspection/UndeclaredTestInspection.getShortName must not return null");
        }
        return "UndeclaredTests";
    }

    @Nullable
    public ProblemDescriptor[] checkClass(@NotNull PsiClass aClass, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (aClass == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/theoryinpractice/testng/inspection/UndeclaredTestInspection.checkClass must not be null");
        }
        if (manager == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/theoryinpractice/testng/inspection/UndeclaredTestInspection.checkClass must not be null");
        }
        if (TestNGUtil.hasTest((PsiModifierListOwner)aClass) && PsiClassUtil.isRunnableClass((PsiClass)aClass, (boolean)true)) {
            String[] names;
            Project project = aClass.getProject();
            String qName = aClass.getQualifiedName();
            if (qName == null) {
                return null;
            }
            final String packageQName = ((PsiJavaFile)aClass.getContainingFile()).getPackageName();
            String packageName = StringUtil.getShortName((String)packageQName);
            if (packageQName.length() > 0) {
                String pName = packageName.length() > 0 ? packageName : packageQName;
                names = new String[]{qName, pName};
            } else {
                names = new String[]{qName};
            }
            for (final String name : names) {
                final boolean[] found = new boolean[]{false};
                PsiManager.getInstance((Project)project).getSearchHelper().processUsagesInNonJavaFiles(name, new PsiNonJavaFileReferenceProcessor(){

                    public boolean process(PsiFile file, int startOffset, int endOffset) {
                        if (file.findReferenceAt(startOffset) != null) {
                            if (packageQName.endsWith(name)) {
                                XmlTag tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)file.findElementAt(startOffset), XmlTag.class);
                                if (tag == null || !tag.getName().equals("package")) {
                                    return true;
                                }
                                XmlAttribute attribute = tag.getAttribute("name");
                                if (attribute == null) {
                                    return true;
                                }
                                String value = attribute.getValue();
                                if (!value.equals(StringUtil.getQualifiedName((String)packageQName, (String)"*"))) {
                                    return true;
                                }
                            }
                            found[0] = true;
                            return false;
                        }
                        return true;
                    }
                }, (GlobalSearchScope)new TestNGSearchScope());
                if (!found[0]) continue;
                return null;
            }
            PsiIdentifier nameIdentifier = aClass.getNameIdentifier();
            LOG.assertTrue(nameIdentifier != null);
            return new ProblemDescriptor[]{manager.createProblemDescriptor((PsiElement)nameIdentifier, "Undeclared test '" + aClass.getName() + "'", isOnTheFly, new LocalQuickFix[]{new RegisterClassFix(aClass), new CreateTestngFix()}, ProblemHighlightType.GENERIC_ERROR_OR_WARNING)};
        }
        return null;
    }

    public static void patchTestngXml(XmlFile testngXML, PsiClass psiClass) {
        XmlTag rootTag = testngXML.getDocument().getRootTag();
        if (rootTag != null && rootTag.getName().equals("suite")) {
            try {
                XmlTag classesTag;
                XmlTag testTag = rootTag.findFirstSubTag("test");
                if (testTag == null) {
                    testTag = (XmlTag)rootTag.add((PsiElement)rootTag.createChildTag("test", rootTag.getNamespace(), null, false));
                    testTag.setAttribute("name", psiClass.getName());
                }
                if ((classesTag = testTag.findFirstSubTag("classes")) == null) {
                    classesTag = (XmlTag)testTag.add((PsiElement)testTag.createChildTag("classes", testTag.getNamespace(), null, false));
                }
                XmlTag classTag = (XmlTag)classesTag.add((PsiElement)classesTag.createChildTag("class", classesTag.getNamespace(), null, false));
                String qualifiedName = psiClass.getQualifiedName();
                LOG.assertTrue(qualifiedName != null);
                classTag.setAttribute("name", qualifiedName);
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
            }
        }
    }

    private static class TestNGSearchScope
    extends GlobalSearchScope {
        private TestNGSearchScope() {
        }

        public boolean contains(VirtualFile file) {
            return TestNGUtil.isTestngXML(file);
        }

        public int compare(VirtualFile file1, VirtualFile file2) {
            return 0;
        }

        public boolean isSearchInModuleContent(@NotNull Module aModule) {
            if (aModule == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/theoryinpractice/testng/inspection/UndeclaredTestInspection$TestNGSearchScope.isSearchInModuleContent must not be null");
            }
            return true;
        }

        public boolean isSearchInLibraries() {
            return false;
        }
    }

    private static class CreateTestngFix
    implements LocalQuickFix {
        private CreateTestngFix() {
        }

        @NotNull
        public String getName() {
            if ("Create suite" == null) {
                throw new IllegalStateException("@NotNull method com/theoryinpractice/testng/inspection/UndeclaredTestInspection$CreateTestngFix.getName must not return null");
            }
            return "Create suite";
        }

        @NotNull
        public String getFamilyName() {
            String string = this.getName();
            if (string == null) {
                throw new IllegalStateException("@NotNull method com/theoryinpractice/testng/inspection/UndeclaredTestInspection$CreateTestngFix.getFamilyName must not return null");
            }
            return string;
        }

        public void applyFix(final @NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/theoryinpractice/testng/inspection/UndeclaredTestInspection$CreateTestngFix.applyFix must not be null");
            }
            if (descriptor == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/theoryinpractice/testng/inspection/UndeclaredTestInspection$CreateTestngFix.applyFix must not be null");
            }
            final PsiClass psiClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)descriptor.getPsiElement(), PsiClass.class);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    VirtualFile[] files = FileChooser.chooseFiles((Project)project, (FileChooserDescriptor)new FileChooserDescriptor(false, true, false, false, false, false));
                    if (files.length == 1) {
                        final PsiManager psiManager = PsiManager.getInstance((Project)project);
                        final PsiDirectory directory = psiManager.findDirectory(files[0]);
                        LOG.assertTrue(directory != null);
                        new WriteCommandAction(project, CreateTestngFix.this.getName(), null){

                            protected void run(Result result) throws Throwable {
                                XmlFile testngXml = (XmlFile)PsiFileFactory.getInstance((Project)psiManager.getProject()).createFileFromText("testng.xml", "<!DOCTYPE suite SYSTEM \"http://testng.org/testng-1.0.dtd\">\n<suite></suite>");
                                try {
                                    testngXml = (XmlFile)directory.add((PsiElement)testngXml);
                                }
                                catch (IncorrectOperationException e) {
                                    return;
                                }
                                UndeclaredTestInspection.patchTestngXml(testngXml, psiClass);
                            }
                        }.execute();
                    }
                }
            });
        }
    }

    private static class RegisterClassFix
    implements LocalQuickFix {
        private final PsiClass myClass;

        public RegisterClassFix(PsiClass aClass) {
            this.myClass = aClass;
        }

        @NotNull
        public String getName() {
            String string = "Register '" + this.myClass.getName() + "'";
            if (string == null) {
                throw new IllegalStateException("@NotNull method com/theoryinpractice/testng/inspection/UndeclaredTestInspection$RegisterClassFix.getName must not return null");
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = this.getName();
            if (string == null) {
                throw new IllegalStateException("@NotNull method com/theoryinpractice/testng/inspection/UndeclaredTestInspection$RegisterClassFix.getFamilyName must not return null");
            }
            return string;
        }

        public void applyFix(final @NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/theoryinpractice/testng/inspection/UndeclaredTestInspection$RegisterClassFix.applyFix must not be null");
            }
            if (descriptor == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/theoryinpractice/testng/inspection/UndeclaredTestInspection$RegisterClassFix.applyFix must not be null");
            }
            final PsiClass psiClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)descriptor.getPsiElement(), PsiClass.class);
            LOG.assertTrue(psiClass != null);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    String testngXmlPath = new SuiteBrowser(project).showDialog();
                    if (testngXmlPath == null) {
                        return;
                    }
                    VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByPath(testngXmlPath);
                    LOG.assertTrue(virtualFile != null);
                    PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(virtualFile);
                    LOG.assertTrue(psiFile instanceof XmlFile);
                    final XmlFile testngXML = (XmlFile)psiFile;
                    new WriteCommandAction(project, RegisterClassFix.this.getName(), new PsiFile[]{testngXML}){

                        protected void run(Result result) throws Throwable {
                            UndeclaredTestInspection.patchTestngXml(testngXML, psiClass);
                        }
                    }.execute();
                }
            });
        }
    }
}

