/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.config.ui;

import com.intellij.cvsSupport2.config.CvsApplicationLevelConfiguration;
import com.intellij.cvsSupport2.config.CvsRootConfiguration;
import com.intellij.cvsSupport2.cvsoperations.cvsEdit.ui.EditCvsConfigurationFieldByFieldDialog;
import com.intellij.cvsSupport2.ui.CvsRootChangeListener;
import com.intellij.ui.DocumentAdapter;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.BooleanValueHolder;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class CvsRootAsStringConfigurationPanel {
    private JTextField myCvsRoot;
    private JButton myEditFieldByFieldButton;
    private JLabel myRootLabel;
    private final BooleanValueHolder myIsInUpdating;
    private final Collection<CvsRootChangeListener> myCvsRootListeners;
    private JPanel myPanel;

    public CvsRootAsStringConfigurationPanel(BooleanValueHolder isInUpdating) {
        this.$$$setupUI$$$();
        this.myCvsRootListeners = new ArrayList<CvsRootChangeListener>();
        this.myIsInUpdating = isInUpdating;
        this.myRootLabel.setLabelFor(this.myCvsRoot);
        this.myCvsRoot.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            public void textChanged(DocumentEvent event) {
                CvsRootAsStringConfigurationPanel.this.notifyListeners();
            }
        });
        this.myEditFieldByFieldButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CvsRootConfiguration cvsRootConfiguration = CvsApplicationLevelConfiguration.createNewConfiguration(CvsApplicationLevelConfiguration.getInstance());
                CvsRootAsStringConfigurationPanel.this.saveTo(cvsRootConfiguration, false);
                EditCvsConfigurationFieldByFieldDialog dialog = new EditCvsConfigurationFieldByFieldDialog(CvsRootAsStringConfigurationPanel.this.myCvsRoot.getText());
                dialog.show();
                if (dialog.isOK()) {
                    CvsRootAsStringConfigurationPanel.this.myCvsRoot.setText(dialog.getConfiguration());
                }
            }
        });
    }

    protected void notifyListeners() {
        if (this.myIsInUpdating.getValue()) {
            return;
        }
        for (CvsRootChangeListener cvsRootChangeListener : this.myCvsRootListeners) {
            cvsRootChangeListener.onCvsRootChanged();
        }
    }

    public JPanel getPanel() {
        return this.myPanel;
    }

    public void addCvsRootChangeListener(CvsRootChangeListener listener) {
        this.myCvsRootListeners.add(listener);
    }

    public void updateFrom(CvsRootConfiguration config) {
        this.myCvsRoot.setText(config.CVS_ROOT);
        this.myCvsRoot.selectAll();
        this.myCvsRoot.requestFocus();
    }

    public void saveTo(CvsRootConfiguration config, boolean checkParameters) {
        config.CVS_ROOT = this.myCvsRoot.getText().trim();
    }

    public String getCvsRoot() {
        return this.myCvsRoot.getText().trim();
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myCvsRoot;
    }

    public void setReadOnly() {
        this.myCvsRoot.setEditable(false);
        this.myEditFieldByFieldButton.setEnabled(false);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JButton jButton;
        JTextField jTextField;
        JLabel jLabel;
        JPanel jPanel;
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(3, 3, 3, 3), -1, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myRootLabel = jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("com/intellij/cvsSupport2/CvsBundle").getString("label.cvs.root.field.label"));
        jPanel2.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myCvsRoot = jTextField = new JTextField();
        jTextField.setText("");
        jPanel2.add((Component)jTextField, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(300, 24), null));
        this.myEditFieldByFieldButton = jButton = new JButton();
        this.$$$loadButtonText$$$(jButton, ResourceBundle.getBundle("com/intellij/cvsSupport2/CvsBundle").getString("button.edit.cvs.root.by.field"));
        jPanel2.add((Component)jButton, new GridConstraints(0, 2, 1, 1, 0, 1, 3, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

