/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.security;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.AllPermission;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import net.sourceforge.jnlp.config.DeploymentConfiguration;
import net.sourceforge.jnlp.runtime.Translator;
import net.sourceforge.jnlp.util.FileUtils;

public final class KeyStores {
    public static final Map<Integer, String> keystoresPaths = new HashMap<Integer, String>();
    private static DeploymentConfiguration config = null;
    private static final String KEYSTORE_TYPE = "JKS";
    private static final String DEFAULT_PASSWORD = "changeit";

    public static final char[] getPassword() {
        return DEFAULT_PASSWORD.toCharArray();
    }

    public static void setConfiguration(DeploymentConfiguration newConfig) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new AllPermission());
        }
        config = newConfig;
    }

    public static final KeyStore getKeyStore(Level level, Type type) {
        boolean create = false;
        create = level == Level.USER;
        return KeyStores.getKeyStore(level, type, create);
    }

    public static final KeyStore getKeyStore(Level level, Type type, boolean create) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new AllPermission());
        }
        String location = KeyStores.getKeyStoreLocation(level, type);
        KeyStore ks = null;
        try {
            ks = KeyStores.createKeyStoreFromFile(new File(location), create, DEFAULT_PASSWORD);
            keystoresPaths.put(ks.hashCode(), location);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ks;
    }

    public static String getPathToKeystore(int k) {
        String s = keystoresPaths.get(k);
        if (s == null) {
            return "unknown keystore location";
        }
        return s;
    }

    public static final KeyStore[] getCertKeyStores() {
        ArrayList<KeyStore> result = new ArrayList<KeyStore>(10);
        KeyStore ks = null;
        ks = KeyStores.getKeyStore(Level.SYSTEM, Type.JSSE_CERTS);
        if (ks != null) {
            result.add(ks);
        }
        if ((ks = KeyStores.getKeyStore(Level.SYSTEM, Type.CERTS)) != null) {
            result.add(ks);
        }
        if ((ks = KeyStores.getKeyStore(Level.USER, Type.JSSE_CERTS)) != null) {
            result.add(ks);
        }
        if ((ks = KeyStores.getKeyStore(Level.USER, Type.CERTS)) != null) {
            result.add(ks);
        }
        return result.toArray(new KeyStore[result.size()]);
    }

    public static final KeyStore[] getCAKeyStores() {
        ArrayList<KeyStore> result = new ArrayList<KeyStore>(10);
        KeyStore ks = null;
        ks = KeyStores.getKeyStore(Level.SYSTEM, Type.JSSE_CA_CERTS);
        if (ks != null) {
            result.add(ks);
        }
        if ((ks = KeyStores.getKeyStore(Level.SYSTEM, Type.CA_CERTS)) != null) {
            result.add(ks);
        }
        if ((ks = KeyStores.getKeyStore(Level.USER, Type.JSSE_CA_CERTS)) != null) {
            result.add(ks);
        }
        if ((ks = KeyStores.getKeyStore(Level.USER, Type.CA_CERTS)) != null) {
            result.add(ks);
        }
        return result.toArray(new KeyStore[result.size()]);
    }

    public static KeyStore[] getClientKeyStores() {
        ArrayList<KeyStore> result = new ArrayList<KeyStore>();
        KeyStore ks = null;
        ks = KeyStores.getKeyStore(Level.SYSTEM, Type.CLIENT_CERTS);
        if (ks != null) {
            result.add(ks);
        }
        if ((ks = KeyStores.getKeyStore(Level.USER, Type.CLIENT_CERTS)) != null) {
            result.add(ks);
        }
        return result.toArray(new KeyStore[result.size()]);
    }

    public static final String getKeyStoreLocation(Level level, Type type) {
        String configKey = null;
        block0 : switch (level) {
            case SYSTEM: {
                switch (type) {
                    case JSSE_CA_CERTS: {
                        configKey = "deployment.system.security.jssecacerts";
                        break;
                    }
                    case CA_CERTS: {
                        configKey = "deployment.system.security.cacerts";
                        break;
                    }
                    case JSSE_CERTS: {
                        configKey = "deployment.system.security.trusted.jssecerts";
                        break;
                    }
                    case CERTS: {
                        configKey = "deployment.system.security.trusted.certs";
                        break;
                    }
                    case CLIENT_CERTS: {
                        configKey = "deployment.system.security.trusted.clientautcerts";
                    }
                }
                break;
            }
            case USER: {
                switch (type) {
                    case JSSE_CA_CERTS: {
                        configKey = "deployment.user.security.trusted.jssecacerts";
                        break block0;
                    }
                    case CA_CERTS: {
                        configKey = "deployment.user.security.trusted.cacerts";
                        break block0;
                    }
                    case JSSE_CERTS: {
                        configKey = "deployment.user.security.trusted.jssecerts";
                        break block0;
                    }
                    case CERTS: {
                        configKey = "deployment.user.security.trusted.certs";
                        break block0;
                    }
                    case CLIENT_CERTS: {
                        configKey = "deployment.user.security.trusted.clientauthcerts";
                    }
                }
            }
        }
        if (configKey == null) {
            throw new RuntimeException("Unspported");
        }
        return config.getProperty(configKey);
    }

    public static final String toTranslatableString(Level level, Type type) {
        StringBuilder response = new StringBuilder();
        response.append("KS");
        if (level != null) {
            String levelString = level.toString();
            response.append(levelString.substring(0, 1).toUpperCase());
            response.append(levelString.substring(1).toLowerCase());
        }
        if (type != null) {
            String typeString = type.toString();
            StringTokenizer tokenizer = new StringTokenizer(typeString, "_");
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                response.append(token.substring(0, 1).toUpperCase());
                response.append(token.substring(1).toLowerCase());
            }
        }
        return response.toString();
    }

    public static String toDisplayableString(Level level, Type type) {
        return Translator.R(KeyStores.toTranslatableString(level, type));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final KeyStore createKeyStoreFromFile(File file, boolean createIfNotFound, String password) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        FileInputStream fis = null;
        KeyStore ks = null;
        try {
            if (createIfNotFound && !file.exists()) {
                File parent = file.getParentFile();
                if (!parent.isDirectory() && !parent.mkdirs()) {
                    throw new IOException("unable to create " + parent);
                }
                FileUtils.createRestrictedFile(file, true);
                ks = KeyStore.getInstance(KEYSTORE_TYPE);
                ks.load(null, password.toCharArray());
                FileOutputStream fos = new FileOutputStream(file);
                ks.store(fos, password.toCharArray());
                fos.close();
            }
            if (file.exists()) {
                fis = new FileInputStream(file);
                ks = KeyStore.getInstance(KEYSTORE_TYPE);
                ks.load(fis, password.toCharArray());
            } else {
                ks = KeyStore.getInstance(KEYSTORE_TYPE);
                ks.load(null, password.toCharArray());
            }
        }
        finally {
            if (fis != null) {
                fis.close();
            }
        }
        return ks;
    }

    public static enum Type {
        CERTS,
        JSSE_CERTS,
        CA_CERTS,
        JSSE_CA_CERTS,
        CLIENT_CERTS;

    }

    public static enum Level {
        USER,
        SYSTEM;

    }
}

