/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.cache;

import java.io.File;
import java.io.IOException;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sourceforge.jnlp.cache.LruCacheException;
import net.sourceforge.jnlp.runtime.JNLPRuntime;
import net.sourceforge.jnlp.runtime.Translator;
import net.sourceforge.jnlp.util.FileUtils;
import net.sourceforge.jnlp.util.PropertiesFile;

enum CacheLRUWrapper {
    INSTANCE;

    private int lockCount = 0;
    private FileLock fl = null;
    private final String setCachePath = JNLPRuntime.getConfiguration().getProperty("deployment.user.cachedir");
    private final String cacheDir = new File(this.setCachePath != null ? this.setCachePath : System.getProperty("java.io.tmpdir")).getPath();
    private PropertiesFile cacheOrder = new PropertiesFile(new File(this.cacheDir + File.separator + "recently_used"));

    private CacheLRUWrapper() {
        File f = this.cacheOrder.getStoreFile();
        if (!f.exists()) {
            try {
                FileUtils.createParentDir(f);
                FileUtils.createRestrictedFile(f, true);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static CacheLRUWrapper getInstance() {
        return INSTANCE;
    }

    public synchronized void load() {
        boolean loaded = this.cacheOrder.load();
        if (loaded && this.checkData()) {
            if (JNLPRuntime.isDebug()) {
                new LruCacheException().printStackTrace();
            }
            System.out.println(Translator.R("CFakeCache"));
            this.store();
            System.out.println(Translator.R("CFakedCache"));
        }
    }

    private boolean checkData() {
        boolean modified = false;
        Set<Map.Entry<Object, Object>> q = this.cacheOrder.entrySet();
        Iterator<Map.Entry<Object, Object>> it = q.iterator();
        while (it.hasNext()) {
            Map.Entry<Object, Object> currentEntry = it.next();
            String key = (String)currentEntry.getKey();
            String path = (String)currentEntry.getValue();
            try {
                String[] sa = key.split(",");
                Long l1 = Long.parseLong(sa[0]);
                Long l2 = Long.parseLong(sa[1]);
            }
            catch (Exception ex) {
                it.remove();
                modified = true;
                continue;
            }
            if (path != null) {
                if (path.indexOf(this.cacheDir) >= 0) continue;
                it.remove();
                modified = true;
                continue;
            }
            it.remove();
            modified = true;
        }
        return modified;
    }

    public synchronized void store() {
        this.cacheOrder.store();
    }

    public synchronized boolean addEntry(String key, String path) {
        if (this.cacheOrder.containsKey(key)) {
            return false;
        }
        this.cacheOrder.setProperty(key, path);
        return true;
    }

    public synchronized boolean removeEntry(String key) {
        if (!this.cacheOrder.containsKey(key)) {
            return false;
        }
        this.cacheOrder.remove(key);
        return true;
    }

    private String getIdForCacheFolder(String folder) {
        int len = this.cacheDir.length();
        int index = folder.indexOf(File.separatorChar, len + 1);
        return folder.substring(len + 1, index);
    }

    public synchronized boolean updateEntry(String oldKey) {
        if (!this.cacheOrder.containsKey(oldKey)) {
            return false;
        }
        String value = this.cacheOrder.getProperty(oldKey);
        String folder = this.getIdForCacheFolder(value);
        this.cacheOrder.remove(oldKey);
        this.cacheOrder.setProperty(Long.toString(System.currentTimeMillis()) + "," + folder, value);
        return true;
    }

    public synchronized List<Map.Entry<String, String>> getLRUSortedEntries() {
        ArrayList<Map.Entry<String, String>> entries = new ArrayList<Map.Entry<String, String>>(this.cacheOrder.entrySet());
        Collections.sort(entries, new Comparator<Map.Entry<String, String>>(){

            @Override
            public int compare(Map.Entry<String, String> e1, Map.Entry<String, String> e2) {
                Long t2;
                Long t1 = Long.parseLong(e1.getKey().split(",")[0]);
                int c = t1.compareTo(t2 = Long.valueOf(Long.parseLong(e2.getKey().split(",")[0])));
                return c < 0 ? 1 : (c > 0 ? -1 : 0);
            }
        });
        return entries;
    }

    public synchronized void lock() {
        try {
            this.fl = FileUtils.getFileLock(this.cacheOrder.getStoreFile().getPath(), false, true);
        }
        catch (OverlappingFileLockException e) {
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (this.fl != null) {
            ++this.lockCount;
        }
    }

    public synchronized void unlock() {
        if (this.fl != null) {
            --this.lockCount;
            try {
                if (this.lockCount == 0) {
                    this.fl.release();
                    this.fl.channel().close();
                    this.fl = null;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public synchronized String getValue(String key) {
        return this.cacheOrder.getProperty(key);
    }

    public synchronized boolean contains(String key) {
        return this.cacheOrder.contains(key);
    }

    public String generateKey(String path) {
        return System.currentTimeMillis() + "," + this.getIdForCacheFolder(path);
    }

    void clearLRUSortedEntries() {
        this.cacheOrder.clear();
    }
}

