/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import net.sourceforge.jnlp.AppletDesc;
import net.sourceforge.jnlp.DownloadOptions;
import net.sourceforge.jnlp.JARDesc;
import net.sourceforge.jnlp.JNLPCreator;
import net.sourceforge.jnlp.JNLPFile;
import net.sourceforge.jnlp.ResourcesDesc;
import net.sourceforge.jnlp.SecurityDesc;
import net.sourceforge.jnlp.Version;
import net.sourceforge.jnlp.runtime.JNLPRuntime;

public class PluginBridge
extends JNLPFile {
    private String name;
    private Set<String> jars = new HashSet<String>();
    private List<String> codeBaseFolders = new ArrayList<String>();
    private String[] cacheJars = new String[0];
    private String[] cacheExJars = new String[0];
    private Map<String, String> atts;
    private boolean usePack;
    private boolean useVersion;
    private boolean codeBaseLookup;
    private boolean useJNLPHref;

    public PluginBridge(URL codebase, URL documentBase, String jar, String main, int width, int height, Map<String, String> atts, String uKey) throws Exception {
        this(codebase, documentBase, jar, main, width, height, atts, uKey, new JNLPCreator());
    }

    private void addArchiveEntries(String[] archives) {
        for (String archiveEntry : archives) {
            if ((archiveEntry = archiveEntry.trim()).endsWith("/") || archiveEntry.endsWith(File.pathSeparator)) {
                this.codeBaseFolders.add(archiveEntry);
                continue;
            }
            this.jars.add(archiveEntry);
        }
    }

    public PluginBridge(URL codebase, URL documentBase, String archive, String main, int width, int height, Map<String, String> atts, String uKey, JNLPCreator jnlpCreator) throws Exception {
        String cbl;
        String cacheArchiveEx;
        this.specVersion = new Version("1.0");
        this.fileVersion = new Version("1.1");
        this.codeBase = codebase;
        this.sourceLocation = documentBase;
        this.atts = atts;
        if (atts.containsKey("jnlp_href")) {
            this.useJNLPHref = true;
            try {
                JARDesc[] jarDescs;
                URL jnlp = new URL(this.codeBase, atts.get("jnlp_href"));
                JNLPFile jnlpFile = jnlpCreator.create(jnlp, null, false, JNLPRuntime.getDefaultUpdatePolicy(), this.codeBase);
                Map<String, String> jnlpParams = jnlpFile.getApplet().getParameters();
                this.info = jnlpFile.info;
                for (Map.Entry<String, String> entry : jnlpParams.entrySet()) {
                    this.atts.put(entry.getKey().toLowerCase(), entry.getValue());
                }
                for (JARDesc jarDesc : jarDescs = jnlpFile.getResources().getJARs()) {
                    String fileName = jarDesc.getLocation().toExternalForm();
                    this.jars.add(fileName);
                }
            }
            catch (MalformedURLException e) {
                System.err.println("Unable to get JNLP file at: " + atts.get("jnlp_href") + " with context of URL as: " + this.codeBase.toExternalForm());
            }
        } else {
            this.info = new ArrayList();
            this.useJNLPHref = false;
        }
        String cacheArchive = atts.get("cache_archive");
        if (cacheArchive != null && cacheArchive.length() > 0) {
            String[] versions = new String[]{};
            String cacheVersion = atts.get("cache_version");
            if (cacheVersion != null) {
                versions = cacheVersion.split(",");
            }
            String[] jars = cacheArchive.split(",");
            this.cacheJars = new String[jars.length];
            for (int i = 0; i < jars.length; ++i) {
                this.cacheJars[i] = jars[i].trim();
                if (versions.length <= 0) continue;
                int n = i;
                this.cacheJars[n] = this.cacheJars[n] + ";" + versions[i].trim();
            }
        }
        if ((cacheArchiveEx = atts.get("cache_archive_ex")) != null && cacheArchiveEx.length() > 0) {
            this.cacheExJars = cacheArchiveEx.split(",");
        }
        if (archive != null && archive.length() > 0) {
            String[] archives = archive.split(",");
            this.addArchiveEntries(archives);
            if (JNLPRuntime.isDebug()) {
                System.err.println("Jar string: " + archive);
                System.err.println("jars length: " + archives.length);
            }
        }
        this.name = atts.get("name");
        this.name = this.name == null ? "Applet" : this.name + " applet";
        if (main.endsWith(".class")) {
            main = main.substring(0, main.length() - 6);
        }
        String mainClass = main.replace('/', '.');
        this.launchType = new AppletDesc(this.name, mainClass, documentBase, width, height, atts);
        this.security = main.endsWith(".class") ? new SecurityDesc(this, SecurityDesc.SANDBOX_PERMISSIONS, codebase.getHost()) : null;
        this.uniqueKey = uKey;
        this.usePack = false;
        this.useVersion = false;
        String jargs = atts.get("java_arguments");
        if (jargs != null) {
            for (String s : jargs.split(" ")) {
                String[] parts = s.trim().split("=");
                if (parts.length != 2 || !Boolean.valueOf(parts[1]).booleanValue()) continue;
                if ("-Djnlp.packEnabled".equals(parts[0])) {
                    this.usePack = true;
                    continue;
                }
                if (!"-Djnlp.versionEnabled".equals(parts[0])) continue;
                this.useVersion = true;
            }
        }
        this.codeBaseLookup = (cbl = atts.get("codebase_lookup")) == null || Boolean.valueOf(cbl) != false;
    }

    public boolean codeBaseLookup() {
        return this.codeBaseLookup;
    }

    public boolean useJNLPHref() {
        return this.useJNLPHref;
    }

    @Override
    public DownloadOptions getDownloadOptionsForJar(JARDesc jar) {
        return new DownloadOptions(this.usePack, this.useVersion);
    }

    @Override
    public String getTitle() {
        return this.name;
    }

    @Override
    public ResourcesDesc getResources(Locale locale, String os, String arch) {
        return new ResourcesDesc(this, new Locale[]{locale}, new String[]{os}, new String[]{arch}){

            @Override
            public <T> List<T> getResources(Class<T> launchType) {
                if (launchType.equals(JARDesc.class)) {
                    try {
                        Version version;
                        String jar;
                        ArrayList<JARDesc> jarDescs = new ArrayList<JARDesc>();
                        jarDescs.addAll(PluginBridge.this.sharedResources.getResources(JARDesc.class));
                        for (String name : PluginBridge.this.jars) {
                            if (name.length() <= 0) continue;
                            jarDescs.add(new JARDesc(new URL(PluginBridge.this.codeBase, name), null, null, false, true, false, true));
                        }
                        boolean cacheable = true;
                        String cacheOption = (String)PluginBridge.this.atts.get("cache_option");
                        if (cacheOption != null && cacheOption.equalsIgnoreCase("no")) {
                            cacheable = false;
                        }
                        for (String cacheJar : PluginBridge.this.cacheJars) {
                            String[] jarAndVer = cacheJar.split(";");
                            jar = jarAndVer[0];
                            version = null;
                            if (jar.length() == 0) continue;
                            if (jarAndVer.length > 1) {
                                version = new Version(jarAndVer[1]);
                            }
                            jarDescs.add(new JARDesc(new URL(PluginBridge.this.codeBase, jar), version, null, false, true, false, cacheable));
                        }
                        for (String cacheExJar : PluginBridge.this.cacheExJars) {
                            if (cacheExJar.length() == 0) continue;
                            String[] jarInfo = cacheExJar.split(";");
                            jar = jarInfo[0].trim();
                            version = null;
                            boolean lazy = true;
                            if (jarInfo.length > 1) {
                                if (jarInfo[1].equals("preload")) {
                                    lazy = false;
                                } else {
                                    version = new Version(jarInfo[1].trim());
                                }
                                if (jarInfo.length > 2) {
                                    lazy = false;
                                    version = new Version(jarInfo[2].trim());
                                }
                            }
                            jarDescs.add(new JARDesc(new URL(PluginBridge.this.codeBase, jar), version, null, lazy, true, false, false));
                        }
                        ArrayList<JARDesc> result = jarDescs;
                        return result;
                    }
                    catch (MalformedURLException malformedURLException) {
                        // empty catch block
                    }
                }
                return PluginBridge.this.sharedResources.getResources(launchType);
            }

            @Override
            public JARDesc[] getJARs() {
                List<JARDesc> jarDescs = this.getResources(JARDesc.class);
                return jarDescs.toArray(new JARDesc[jarDescs.size()]);
            }

            @Override
            public void addResource(Object resource) {
                PluginBridge.this.sharedResources.addResource(resource);
            }
        };
    }

    public List<String> getCodeBaseFolders() {
        return new ArrayList<String>(this.codeBaseFolders);
    }

    @Override
    public ResourcesDesc[] getResourcesDescs(Locale locale, String os, String arch) {
        return new ResourcesDesc[]{this.getResources(locale, os, arch)};
    }

    @Override
    public boolean isApplet() {
        return true;
    }

    @Override
    public boolean isApplication() {
        return false;
    }

    @Override
    public boolean isComponent() {
        return false;
    }

    @Override
    public boolean isInstaller() {
        return false;
    }
}

