#!/bin/sh
echo 'name: vector
version: 0.10.0.1
id: vector-0.10.0.1-8398066fa66cdbff397fa1d47fe95cbe

license: BSD3
copyright: (c) Roman Leshchinskiy 2008-2012
maintainer: Roman Leshchinskiy <rl@cse.unsw.edu.au>
stability:
homepage: http://code.haskell.org/vector
package-url:
synopsis: Efficient Arrays
description:  
             .
             An efficient implementation of Int-indexed arrays (both mutable
             and immutable), with a powerful loop optimisation framework .
             .
             It is structured as follows:
             .
             ["Data.Vector"] Boxed vectors of arbitrary types.
             .
             ["Data.Vector.Unboxed"] Unboxed vectors with an adaptive
             representation based on data type families.
             .
             ["Data.Vector.Storable"] Unboxed vectors of '\''Storable'\'' types.
             .
             ["Data.Vector.Primitive"] Unboxed vectors of primitive types as
             defined by the @primitive@ package. "Data.Vector.Unboxed" is more
             flexible at no performance cost.
             .
             ["Data.Vector.Generic"] Generic interface to the vector types.
             .
             There is also a (draft) tutorial on common uses of vector.
             .
             * <http://haskell.org/haskellwiki/Numeric_Haskell:_A_Vector_Tutorial>
             .
             Please use the project trac to submit bug reports and feature
             requests.
             .
             * <http://trac.haskell.org/vector>
             .
             Changes in version 0.10.0.1
             .
             * Require @primitive@ to include workaround for a GHC array copying bug
             .
             Changes in version 0.10
             .
             * @NFData@ instances
             .
             * More efficient block fills
             .
             * Safe Haskell support removed
             .
category: Data, Data Structures
author: Roman Leshchinskiy <rl@cse.unsw.edu.au>
pkgpath: devel/hs-vector
exposed: True
exposed-modules: Data.Vector.Internal.Check Data.Vector.Fusion.Util
                 Data.Vector.Fusion.Stream.Size Data.Vector.Fusion.Stream.Monadic
                 Data.Vector.Fusion.Stream Data.Vector.Generic.Mutable
                 Data.Vector.Generic.Base Data.Vector.Generic.New
                 Data.Vector.Generic Data.Vector.Primitive.Mutable
                 Data.Vector.Primitive Data.Vector.Storable.Internal
                 Data.Vector.Storable.Mutable Data.Vector.Storable
                 Data.Vector.Unboxed.Base Data.Vector.Unboxed.Mutable
                 Data.Vector.Unboxed Data.Vector.Mutable Data.Vector
hidden-modules:
trusted: False
import-dirs: /usr/local/lib/ghc/vector-0.10.0.1
library-dirs: /usr/local/lib/ghc/vector-0.10.0.1
hs-libraries: HSvector-0.10.0.1
extra-libraries:
extra-ghci-libraries:
include-dirs: /usr/local/lib/ghc/vector-0.10.0.1/include
includes:
depends: base-4.6.0.1-185478ee9bcc4ae00bc1dbe06bac6937
         deepseq-1.3.0.1-aa1be128186a233c7290faf88620ffe5
         ghc-prim-0.3.0.0-00db43fcd2f6e2a73243bdb496b765e0
         primitive-0.5.0.1-260c8f143868c49f07653c18a9e6d8dc
hugs-options:
cc-options:
ld-options:
framework-dirs:
frameworks:
haddock-interfaces: /usr/local/share/doc/hs-vector-0.10.0.1/html/vector.haddock
haddock-html: /usr/local/share/doc/hs-vector-0.10.0.1/html
' | '/usr/local/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-db' "$@"
