#!/bin/sh
echo 'name: mwc-random
version: 0.12.0.1
id: mwc-random-0.12.0.1-005a6da460373c3cc9f54fd5037da418

license: BSD3
copyright: 2009, 2010, 2011 Bryan O'\''Sullivan
maintainer: Bryan O'\''Sullivan <bos@serpentine.com>
stability:
homepage: https://github.com/bos/mwc-random
package-url:
synopsis: Fast, high quality pseudo random number generation
description: This package contains code for generating high quality random
             numbers that follow either a uniform or normal distribution.  The
             generated numbers are suitable for use in statistical applications.
             .
             The uniform PRNG uses Marsaglia'\''s MWC256 (also known as MWC8222)
             multiply-with-carry generator, which has a period of 2^8222 and
             fares well in tests of randomness.  It is also extremely fast,
             between 2 and 3 times faster than the Mersenne Twister.
             .
             Compared to the mersenne-random package, this package has a more
             convenient API, is faster, and supports more statistical
             distributions.
category: Math, Statistics
author: Bryan O'\''Sullivan <bos@serpentine.com>
pkgpath: security/hs-mwc-random
exposed: True
exposed-modules: System.Random.MWC System.Random.MWC.Distributions
                 System.Random.MWC.CondensedTable
hidden-modules:
trusted: False
import-dirs: /usr/local/lib/ghc/mwc-random-0.12.0.1
library-dirs: /usr/local/lib/ghc/mwc-random-0.12.0.1
hs-libraries: HSmwc-random-0.12.0.1
extra-libraries:
extra-ghci-libraries:
include-dirs:
includes:
depends: base-4.6.0.1-185478ee9bcc4ae00bc1dbe06bac6937
         primitive-0.5.0.1-260c8f143868c49f07653c18a9e6d8dc
         time-1.4.0.1-11ddabfbdd9e1882a9135b100d37881b
         vector-0.10.0.1-8398066fa66cdbff397fa1d47fe95cbe
hugs-options:
cc-options:
ld-options:
framework-dirs:
frameworks:
haddock-interfaces: /usr/local/share/doc/hs-mwc-random-0.12.0.1/html/mwc-random.haddock
haddock-html: /usr/local/share/doc/hs-mwc-random-0.12.0.1/html
' | '/usr/local/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-db' "$@"
