#!/bin/sh
echo 'name: lens
version: 3.7.6
id: lens-3.7.6-c15c4a559d085cb397da19f3ffe792ec

license: BSD3
copyright: Copyright (C) 2012 Edward A. Kmett
maintainer: Edward A. Kmett <ekmett@gmail.com>
stability: provisional
homepage: http://github.com/ekmett/lens/
package-url:
synopsis: Lenses, Folds and Traversals
description: This package comes \"Batteries Included\" with many useful lenses for the types
             commonly used from the Haskell Platform, and with tools for automatically
             generating lenses and isomorphisms for user-supplied data types.
             .
             The combinators in @Control.Lens@ provide a highly generic toolbox for composing
             families of getters, folds, isomorphisms, traversals, setters and lenses and their
             indexed variants.
             .
             An overview, with a large number of examples can be found in the README.
             .
             <https://github.com/ekmett/lens#lens-lenses-folds-and-traversals>
             .
             More information on the care and feeding of lenses, including a brief tutorial and motivation
             for their types can be found on the lens wiki.
             .
             <https://github.com/ekmett/lens/wiki>
             .
             A small game that manages its state using lenses can be found in the example folder.
             .
             <https://github.com/ekmett/lens/blob/master/examples/Pong.hs>
             .
             /Lenses, Folds and Traversals/
             .
             The core of this hierarchy looks like:
             .
             <<http://i.imgur.com/FgfVW.png>>
             .
             You can compose any two elements of the hierarchy above using (.) from the Prelude, and you can
             use any element of the hierarchy as any type it linked to above it.
             .
             The result is their lowest upper bound in the hierarchy (or an error if that bound doesn'\''t exist).
             .
             For instance:
             .
             * You can use any '\''Traversal'\'' as a '\''Fold'\'' or as a '\''Setter'\''.
             .
             * The composition of a '\''Traversal'\'' and a '\''Getter'\'' yields a '\''Fold'\''.
             .
             /Minimizing Dependencies/
             .
             If you want to provide lenses and traversals for your own types in your own libraries, then you
             can do so without incurring a dependency on this (or any other) lens package at all.
             .
             /e.g./ for a data type:
             .
             > data Foo a = Foo Int Int a
             .
             You can define lenses such as
             .
             > -- bar :: Simple Lens (Foo a) Int
             > bar :: Functor f => (Int -> f Int) -> Foo a -> f (Foo a)
             > bar f (Foo a b c) = fmap (\a'\'' -> Foo a'\'' b c) (f a)
             .
             > -- baz :: Lens (Foo a) (Foo b) a b
             > quux :: Functor f => (a -> f b) -> Foo a -> f (Foo b)
             > quux f (Foo a b c) = fmap (Foo a b) (f c)
             .
             without the need to use any type that isn'\''t already defined in the @Prelude@.
             .
             And you can define a traversal of multiple fields with '\''Control.Applicative.Applicative'\'':
             .
             > -- traverseBarAndBaz :: Simple Traversal (Foo a) Int
             > traverseBarAndBaz :: Applicative f => (Int -> f Int) -> Foo a -> f (Foo a)
             > traverseBarAndBaz f (Foo a b c) = Foo <$> f a <*> f b <*> pure c
             .
             What is provided in this library is a number of stock lenses and traversals for
             common haskell types, a wide array of combinators for working them, and more
             exotic functionality, (/e.g./ getters, setters, indexed folds, isomorphisms).
category: Data, Lenses
author: Edward A. Kmett
pkgpath: devel/hs-lens
exposed: True
exposed-modules: Control.Lens.TH Language.Haskell.TH.Lens
                 Control.Exception.Lens Control.Lens Control.Lens.Action
                 Control.Lens.Classes Control.Lens.Combinators Control.Lens.Each
                 Control.Lens.Fold Control.Lens.Getter Control.Lens.Indexed
                 Control.Lens.IndexedGetter Control.Lens.IndexedFold
                 Control.Lens.IndexedLens Control.Lens.IndexedSetter
                 Control.Lens.IndexedTraversal Control.Lens.Internal
                 Control.Lens.Internal.Zipper Control.Lens.Iso Control.Lens.Loupe
                 Control.Lens.Plated Control.Lens.Prism Control.Lens.Representable
                 Control.Lens.Setter Control.Lens.Simple Control.Lens.Traversal
                 Control.Lens.Tuple Control.Lens.Type Control.Lens.WithIndex
                 Control.Lens.Wrapped Control.Lens.Zipper Control.Lens.Zoom
                 Data.Bits.Lens Data.ByteString.Lens Data.ByteString.Strict.Lens
                 Data.ByteString.Lazy.Lens Data.Complex.Lens Data.Data.Lens
                 Data.Dynamic.Lens Data.HashSet.Lens Data.IntSet.Lens Data.List.Lens
                 Data.List.Split.Lens Data.Sequence.Lens Data.Set.Lens
                 Data.Text.Lens Data.Text.Strict.Lens Data.Text.Lazy.Lens
                 Data.Tree.Lens Data.Typeable.Lens Data.Vector.Lens
                 Data.Vector.Generic.Lens GHC.Generics.Lens Data.Array.Lens
                 System.FilePath.Lens Control.Parallel.Strategies.Lens
                 Control.Seq.Lens
hidden-modules: Control.Lens.Internal.Combinators
trusted: False
import-dirs: /usr/local/lib/ghc/lens-3.7.6
library-dirs: /usr/local/lib/ghc/lens-3.7.6
hs-libraries: HSlens-3.7.6
extra-libraries:
extra-ghci-libraries:
include-dirs:
includes:
depends: array-0.4.0.1-6380782b62ead58fec616aa07dc0e15c
         base-4.6.0.1-185478ee9bcc4ae00bc1dbe06bac6937
         bytestring-0.10.0.2-fdb789c5db2e1ca48eb014403eee81b4
         comonad-3.0.3-97c2b9aaa661ce271befc6b439457331
         comonad-transformers-3.0.3-586ab1d3d604aeaa2bfbf4f74e74ec82
         comonads-fd-3.0.2-c26901daad659ad9557e65e315398b88
         containers-0.5.0.0-3b8b869ec10d44736414ab5bea776319
         filepath-1.3.0.1-edbc3d8247914b04f448e9261e7fe895
         ghc-prim-0.3.0.0-00db43fcd2f6e2a73243bdb496b765e0
         hashable-1.1.2.5-93ac9e8f4902e70447854e208345383a
         mtl-2.1.2-735d9c92b4f214d454fb5168bb1eb6ee
         nats-0.1-aec08333f55fa44b719505dcb3893327
         parallel-3.2.0.3-e820b19f5a9c77af99f9f74ca067f604
         semigroups-0.9.2-51d976447c6408479cabc66ac9867fc6
         split-0.2.2-da1c8aaae88e58aebda2b8c3fd552806
         template-haskell-2.8.0.0-ac0663b70333f59eeec24f3cf48cfb28
         text-0.11.3.1-3fa3b4cb4ca4c0f49eeebe965c439ff9
         transformers-0.3.0.0-948c0bbaafc952a144be4248ffa27cb1
         unordered-containers-0.2.3.0-5bf92a1c1b90f6e2e5a5dbbd8a6ab013
         vector-0.10.0.1-8398066fa66cdbff397fa1d47fe95cbe
hugs-options:
cc-options:
ld-options:
framework-dirs:
frameworks:
haddock-interfaces: /usr/local/share/doc/hs-lens-3.7.6/html/lens.haddock
haddock-html: /usr/local/share/doc/hs-lens-3.7.6/html
' | '/usr/local/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-db' "$@"
