#!/bin/sh
echo 'name: heist
version: 0.12.0
id: heist-0.12.0-ad707bdadab21f42175ad4aa6f873a8d

license: BSD3
copyright:
maintainer: snap@snapframework.com
stability:
homepage: http://snapframework.com/
package-url:
synopsis: An Haskell template system supporting both HTML5 and XML.
description: Heist is a powerful template system that supports both HTML5 and XML.
             Some of Heist'\''s features are:
             .
             * Designer-friendly HTML5 (or XML) syntax
             .
             * Templates can be reloaded to make changes visible without recompiling
             your Haskell code
             .
             * Enforces near-perfect separation of business logic and view
             .
             * Powerful abstraction primitives allowing you to eliminate repetition
             .
             * Easy creation of domain-specific markup languages
             .
             * Built-in support for including JSON and Markdown content in templates
             .
             * Simple mechanism for designer-specified template caching
             .
             * Optional merging of multiple \<head\> tags defined anywhere in the
             document
category: Web, Snap
author: Doug Beardsley, Gregory Collins
pkgpath: textproc/hs-heist
exposed: True
exposed-modules: Heist Heist.Compiled Heist.Interpreted
                 Heist.Splices Heist.Splices.Apply Heist.Splices.Bind
                 Heist.Splices.BindStrict Heist.Splices.Cache Heist.Splices.Html
                 Heist.Splices.Ignore Heist.Splices.Json Heist.Splices.Markdown
                 Heist.TemplateDirectory
hidden-modules: Data.HeterogeneousEnvironment Heist.Common
                Heist.Compiled.Internal Heist.Interpreted.Internal Heist.Types
trusted: False
import-dirs: /usr/local/lib/ghc/heist-0.12.0
library-dirs: /usr/local/lib/ghc/heist-0.12.0
hs-libraries: HSheist-0.12.0
extra-libraries:
extra-ghci-libraries:
include-dirs:
includes:
depends: MonadCatchIO-transformers-0.3.0.0-9df3c38f0408c0a91e2a32a7584ef9c9
         aeson-0.6.0.2-5c5998e8fd3dd21476ca10d62df94bd2
         attoparsec-0.10.4.0-fb379774679ae5734f1b536d33d902ec
         base-4.6.0.1-185478ee9bcc4ae00bc1dbe06bac6937
         blaze-builder-0.3.1.1-ac49b512143342e2370aead8ef93c70b
         blaze-html-0.6.1.1-d9a2e0519a92c20d0751dbc779791ce7
         bytestring-0.10.0.2-fdb789c5db2e1ca48eb014403eee81b4
         containers-0.5.0.0-3b8b869ec10d44736414ab5bea776319
         directory-1.2.0.1-5cea89dab5fade71d74e1fcf13ee5ca4
         directory-tree-0.11.0-0f25d13869a5d7392e7d0db657bc695a
         dlist-0.5-537820b285fbaec1d5ce98a12ca093d8
         errors-1.4.2-73bc5745c94faaf6fd26a488bb91c414
         filepath-1.3.0.1-edbc3d8247914b04f448e9261e7fe895
         hashable-1.1.2.5-93ac9e8f4902e70447854e208345383a
         mtl-2.1.2-735d9c92b4f214d454fb5168bb1eb6ee
         process-1.1.0.2-a830d25f0e9fb9c610aa641b7f5b20f9
         random-1.0.1.1-de2c78bd5b6a198d2ecb982e7d11c02f
         text-0.11.3.1-3fa3b4cb4ca4c0f49eeebe965c439ff9
         time-1.4.0.1-11ddabfbdd9e1882a9135b100d37881b
         transformers-0.3.0.0-948c0bbaafc952a144be4248ffa27cb1
         unordered-containers-0.2.3.0-5bf92a1c1b90f6e2e5a5dbbd8a6ab013
         vector-0.10.0.1-8398066fa66cdbff397fa1d47fe95cbe
         xmlhtml-0.2.1-024fbdca2ca705169920f98d3cb47c28
hugs-options:
cc-options:
ld-options:
framework-dirs:
frameworks:
haddock-interfaces: /usr/local/share/doc/hs-heist-0.12.0/html/heist.haddock
haddock-html: /usr/local/share/doc/hs-heist-0.12.0/html
' | '/usr/local/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-db' "$@"
