#!/bin/sh
echo 'name: hashed-storage
version: 0.5.10
id: hashed-storage-0.5.10-7cfee37f2bc3a50c6a9a90a0d74af63d

license: BSD3
copyright: 2009 Petr Rockai <me@mornfall.net>
maintainer: Petr Rockai <me@mornfall.net>
stability:
homepage:
package-url:
synopsis: Hashed file storage support code.
description: Support code for reading and manipulating hashed file storage
             (where each file and directory is associated with a
             cryptographic hash, for corruption-resistant storage and fast
             comparisons).
             .
             The supported storage formats include darcs hashed pristine, a
             plain filesystem tree and an indexed plain tree (where the index
             maintains hashes of the plain files and directories).
category: System
author: Petr Rockai <me@mornfall.net>
pkgpath: devel/hs-hashed-storage
exposed: True
exposed-modules: Storage.Hashed Storage.Hashed.AnchoredPath
                 Storage.Hashed.Index Storage.Hashed.Monad Storage.Hashed.Tree
                 Storage.Hashed.Hash Storage.Hashed.Packed Storage.Hashed.Plain
                 Storage.Hashed.Darcs
hidden-modules: Bundled.Posix Bundled.SHA256 Storage.Hashed.Utils
trusted: False
import-dirs: /usr/local/lib/ghc/hashed-storage-0.5.10
library-dirs: /usr/local/lib/ghc/hashed-storage-0.5.10
hs-libraries: HShashed-storage-0.5.10
extra-libraries:
extra-ghci-libraries:
include-dirs:
includes:
depends: base-4.6.0.1-185478ee9bcc4ae00bc1dbe06bac6937
         binary-0.5.1.1-74732d5b56a09e03422b1871cb0426b3
         bytestring-0.10.0.2-fdb789c5db2e1ca48eb014403eee81b4
         containers-0.5.0.0-3b8b869ec10d44736414ab5bea776319
         dataenc-0.14.0.5-9969cfa6c78bd699cf9b75c7c37154a1
         directory-1.2.0.1-5cea89dab5fade71d74e1fcf13ee5ca4
         extensible-exceptions-0.1.1.4-255a395b3b026cb94b23754e1c372785
         filepath-1.3.0.1-edbc3d8247914b04f448e9261e7fe895
         mmap-0.5.8-eebbdde67c5a33fe7e439db44e0256ba
         mtl-2.1.2-735d9c92b4f214d454fb5168bb1eb6ee
         zlib-0.5.4.1-f8b2bb965704e7ec5caa162d83990faa
hugs-options:
cc-options:
ld-options:
framework-dirs:
frameworks:
haddock-interfaces: /usr/local/share/doc/hs-hashed-storage-0.5.10/html/hashed-storage.haddock
haddock-html: /usr/local/share/doc/hs-hashed-storage-0.5.10/html
' | '/usr/local/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-db' "$@"
