#!/bin/sh
echo 'name: crypto-api
version: 0.10.2
id: crypto-api-0.10.2-ed965d5175b0edb9939073f02a068b59

license: BSD3
copyright: Thomas DuBuisson <thomas.dubuisson@gmail.com>, Francisco Blas Izquierdo Riera (klondike) (see AUTHORS)
maintainer: Thomas DuBuisson <thomas.dubuisson@gmail.com>
stability: stable
homepage: http://trac.haskell.org/crypto-api/wiki
package-url:
synopsis: A generic interface for cryptographic operations
description: A generic interface for cryptographic operations (hashes, ciphers, randomness).
             Maintainers of hash and cipher implementations are
             encouraged to add instances for the classes defined
             in Crypto.Classes.  Crypto users are similarly
             encouraged to use the interfaces defined in the Classes
             module.
             Any concepts or functions of general use to more than
             one cryptographic algorithm (ex: padding) is within
             scope of this package.
category: Data, Cryptography
author: Thomas DuBuisson <thomas.dubuisson@gmail.com>, Francisco Blas Izquierdo Riera (klondike)
pkgpath: security/hs-crypto-api
exposed: True
exposed-modules: Crypto.Classes Crypto.Types Crypto.HMAC
                 Crypto.Modes Crypto.Random Crypto.Padding
hidden-modules: Crypto.Util Crypto.CPoly
trusted: False
import-dirs: /usr/local/lib/ghc/crypto-api-0.10.2
library-dirs: /usr/local/lib/ghc/crypto-api-0.10.2
hs-libraries: HScrypto-api-0.10.2
extra-libraries:
extra-ghci-libraries:
include-dirs:
includes:
depends: array-0.4.0.1-6380782b62ead58fec616aa07dc0e15c
         base-4.6.0.1-185478ee9bcc4ae00bc1dbe06bac6937
         bytestring-0.10.0.2-fdb789c5db2e1ca48eb014403eee81b4
         cereal-0.3.5.2-a8a790d0768a9248e2a627d1a1b5697e
         entropy-0.2.1-c7e320e77a89e79b228c456a83a4a619
         largeword-1.0.5-932bc806339ed61930996a2f778cad8e
         tagged-0.4.4-cba7ff9b4c1ef8e942d839e784d6f6ae
hugs-options:
cc-options:
ld-options:
framework-dirs:
frameworks:
haddock-interfaces: /usr/local/share/doc/hs-crypto-api-0.10.2/html/crypto-api.haddock
haddock-html: /usr/local/share/doc/hs-crypto-api-0.10.2/html
' | '/usr/local/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-db' "$@"
