#!/bin/sh
echo 'name: cprng-aes
version: 0.2.3
id: cprng-aes-0.2.3-4455172fd693a4bc572bea17191b2bfc

license: BSD3
copyright: Vincent Hanquez <vincent@snarc.org>
maintainer: Vincent Hanquez <vincent@snarc.org>
stability: experimental
homepage: http://github.com/vincenthz/hs-cprng-aes
package-url:
synopsis: Crypto Pseudo Random Number Generator using AES in counter mode.
description: Simple crypto pseudo-random-number-generator with really good randomness property.
             .
             Using ent, a randomness property maker on one 1Mb sample:
             Entropy = 7.999837 bits per byte.
             Optimum compression would reduce the size of this 1048576 byte file by 0 percent.
             Chi square distribution for 1048576 samples is 237.02
             Arithmetic mean value of data bytes is 127.3422 (127.5 = random)
             Monte Carlo value for Pi is 3.143589568 (error 0.06 percent)
             .
             Compared to urandom with the same sampling:
             Entropy = 7.999831 bits per byte.
             Optimum compression would reduce the size of this 1048576 byte file by 0 percent.
             Chi square distribution for 1048576 samples is 246.63
             Arithmetic mean value of data bytes is 127.6347 (127.5 = random).
             Monte Carlo value for Pi is 3.132465868 (error 0.29 percent).
category: Cryptography
author: Vincent Hanquez <vincent@snarc.org>
pkgpath: security/hs-cprng-aes
exposed: True
exposed-modules: Crypto.Random.AESCtr
hidden-modules:
trusted: False
import-dirs: /usr/local/lib/ghc/cprng-aes-0.2.3
library-dirs: /usr/local/lib/ghc/cprng-aes-0.2.3
hs-libraries: HScprng-aes-0.2.3
extra-libraries:
extra-ghci-libraries:
include-dirs:
includes:
depends: base-4.6.0.1-185478ee9bcc4ae00bc1dbe06bac6937
         bytestring-0.10.0.2-fdb789c5db2e1ca48eb014403eee81b4
         cereal-0.3.5.2-a8a790d0768a9248e2a627d1a1b5697e
         crypto-api-0.10.2-ed965d5175b0edb9939073f02a068b59
         cryptocipher-0.2.8-8e22ea2234d6867668f953ed15dd5173
         entropy-0.2.1-c7e320e77a89e79b228c456a83a4a619
         random-1.0.1.1-de2c78bd5b6a198d2ecb982e7d11c02f
hugs-options:
cc-options:
ld-options:
framework-dirs:
frameworks:
haddock-interfaces: /usr/local/share/doc/hs-cprng-aes-0.2.3/html/cprng-aes.haddock
haddock-html: /usr/local/share/doc/hs-cprng-aes-0.2.3/html
' | '/usr/local/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-db' "$@"
