#!/bin/sh
echo 'name: GLURaw
version: 1.3.0.0
id: GLURaw-1.3.0.0-200bbb75f1645d34c670006369febbfe

license: BSD3
copyright:
maintainer: Jason Dagit <dagitj@gmail.com>, Sven Panne <sven.panne@aedion.de>
stability:
homepage: http://www.haskell.org/haskellwiki/Opengl
package-url:
synopsis: A raw binding for the OpenGL graphics system
description: GLURaw is a raw Haskell binding for the GLU 1.3 OpenGL utility library. It is
             basically a 1:1 mapping of GLU'\''s C API, intended as a basis for a nicer
             interface.
             .
             OpenGL is the industry'\''s most widely used and supported 2D and 3D graphics
             application programming interface (API), incorporating a broad set of
             rendering, texture mapping, special effects, and other powerful visualization
             functions. For more information about OpenGL and its various extensions,
             please see <http://www.opengl.org/>
             and <http://www.opengl.org/registry/>.
category: Graphics
author:
pkgpath: graphics/hs-GLURaw
exposed: True
exposed-modules: Graphics.Rendering.GLU.Raw
                 Graphics.Rendering.GLU.Raw.Callbacks
                 Graphics.Rendering.GLU.Raw.Functions
                 Graphics.Rendering.GLU.Raw.Tokens Graphics.Rendering.GLU.Raw.Types
hidden-modules: Graphics.Rendering.GLU.Raw.APIEntry
                Graphics.Rendering.GLU.Raw.TypesInternal
trusted: False
import-dirs: /usr/local/lib/ghc/GLURaw-1.3.0.0
library-dirs: /usr/local/lib/ghc/GLURaw-1.3.0.0 /usr/X11R6/lib
hs-libraries: HSGLURaw-1.3.0.0
extra-libraries: GLU GL
extra-ghci-libraries:
include-dirs: /usr/X11R6/include
includes:
depends: OpenGLRaw-1.3.0.0-6f5bc80dc04e9b14fad26151d827173c
         base-4.6.0.1-185478ee9bcc4ae00bc1dbe06bac6937
hugs-options:
cc-options:
ld-options:
framework-dirs:
frameworks:
haddock-interfaces: /usr/local/share/doc/hs-GLURaw-1.3.0.0/html/GLURaw.haddock
haddock-html: /usr/local/share/doc/hs-GLURaw-1.3.0.0/html
' | '/usr/local/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-db' "$@"
