/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.awt.Color;
import java.awt.Container;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Shape;
import java.awt.Toolkit;
import javax.swing.event.DocumentEvent;
import javax.swing.text.AttributeSet;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.GlyphView;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import javax.swing.text.ViewFactory;

public class LabelView
extends GlyphView {
    Color background;
    Color foreground;
    Font font;
    boolean strikeThrough;
    boolean underline;
    boolean subscript;
    boolean superscript;
    private boolean valid = false;

    public LabelView(Element element) {
        super(element);
    }

    protected void setPropertiesFromAttributes() {
        AttributeSet atts = this.getAttributes();
        this.setStrikeThrough(StyleConstants.isStrikeThrough(atts));
        this.setSubscript(StyleConstants.isSubscript(atts));
        this.setSuperscript(StyleConstants.isSuperscript(atts));
        this.setUnderline(StyleConstants.isUnderline(atts));
        Document d = this.getDocument();
        if (d instanceof StyledDocument) {
            StyledDocument doc = (StyledDocument)d;
            this.font = doc.getFont(atts);
            this.background = atts.isDefined(StyleConstants.Background) ? doc.getBackground(atts) : null;
            this.foreground = doc.getForeground(atts);
        }
        this.valid = true;
    }

    public void changedUpdate(DocumentEvent e, Shape a, ViewFactory vf) {
        this.valid = false;
        super.changedUpdate(e, a, vf);
    }

    public Color getBackground() {
        if (!this.valid) {
            this.setPropertiesFromAttributes();
        }
        return this.background;
    }

    protected void setBackground(Color bg) {
        this.background = bg;
    }

    public Color getForeground() {
        if (!this.valid) {
            this.setPropertiesFromAttributes();
        }
        return this.foreground;
    }

    public Font getFont() {
        if (!this.valid) {
            this.setPropertiesFromAttributes();
        }
        return this.font;
    }

    protected FontMetrics getFontMetrics() {
        Container c;
        if (!this.valid) {
            this.setPropertiesFromAttributes();
        }
        FontMetrics fm = (c = this.getContainer()) != null ? c.getFontMetrics(this.font) : Toolkit.getDefaultToolkit().getFontMetrics(this.font);
        return fm;
    }

    public boolean isUnderline() {
        if (!this.valid) {
            this.setPropertiesFromAttributes();
        }
        return this.underline;
    }

    protected void setUnderline(boolean flag) {
        this.underline = flag;
    }

    public boolean isSubscript() {
        if (!this.valid) {
            this.setPropertiesFromAttributes();
        }
        return this.subscript;
    }

    protected void setSubscript(boolean flag) {
        this.subscript = flag;
    }

    public boolean isSuperscript() {
        if (!this.valid) {
            this.setPropertiesFromAttributes();
        }
        return this.superscript;
    }

    protected void setSuperscript(boolean flag) {
        this.superscript = flag;
    }

    public boolean isStrikeThrough() {
        if (!this.valid) {
            this.setPropertiesFromAttributes();
        }
        return this.strikeThrough;
    }

    protected void setStrikeThrough(boolean flag) {
        this.strikeThrough = flag;
    }
}

