/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.util.Stack;
import javax.swing.text.Document;
import javax.swing.text.Element;

public class ElementIterator
implements Cloneable {
    private Element root;
    private Stack stack;

    public ElementIterator(Document document) {
        this.root = document.getDefaultRootElement();
    }

    public ElementIterator(Element root) {
        this.root = root;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public Element current() {
        Element current;
        if (this.stack == null) {
            current = this.first();
        } else {
            current = null;
            if (!this.stack.isEmpty()) {
                ElementRef ref = (ElementRef)this.stack.peek();
                Element el = ref.element;
                int index = ref.index;
                current = index == -1 ? el : el.getElement(index);
            }
        }
        return current;
    }

    public int depth() {
        int depth = 0;
        if (this.stack != null) {
            depth = this.stack.size();
        }
        return depth;
    }

    public Element first() {
        Element first = null;
        if (this.root != null) {
            this.stack = new Stack();
            if (this.root.getElementCount() > 0) {
                this.stack.push(new ElementRef(this.root));
            }
            first = this.root;
        }
        return first;
    }

    public Element next() {
        Element next;
        if (this.stack == null) {
            next = this.first();
        } else {
            next = null;
            if (!this.stack.isEmpty()) {
                ElementRef ref = (ElementRef)this.stack.peek();
                Element el = ref.element;
                int index = ref.index++;
                if (el.getElementCount() > index + 1) {
                    Element child = el.getElement(index + 1);
                    if (!child.isLeaf()) {
                        this.stack.push(new ElementRef(child));
                    }
                    next = child;
                    next = child;
                } else {
                    this.stack.pop();
                    if (!this.stack.isEmpty()) {
                        ElementRef top = (ElementRef)this.stack.peek();
                        ++top.index;
                        next = this.next();
                    }
                }
            }
        }
        return next;
    }

    public Element previous() {
        Element previous = null;
        if (this.stack != null && this.stack.size() > 0) {
            ElementRef ref = (ElementRef)this.stack.peek();
            Element el = ref.element;
            int index = ref.index;
            if (index > 0) {
                previous = this.deepestLeaf(el.getElement(--index));
            } else if (index == 0) {
                previous = el;
            } else if (index == -1) {
                ElementRef top = (ElementRef)this.stack.pop();
                ElementRef item = (ElementRef)this.stack.peek();
                this.stack.push(top);
                index = item.index;
                el = item.element;
                previous = index == -1 ? el : this.deepestLeaf(el.getElement(index));
            }
        }
        return previous;
    }

    private Element deepestLeaf(Element el) {
        int count;
        Element leaf = el.isLeaf() ? el : ((count = el.getElementCount()) == 0 ? el : this.deepestLeaf(el.getElement(count - 1)));
        return leaf;
    }

    private class ElementRef {
        Element element;
        int index;

        ElementRef(Element el) {
            this.element = el;
            this.index = -1;
        }
    }
}

