/*
 * Decompiled with CFR 0.152.
 */
package javax.crypto.spec;

import java.security.spec.KeySpec;

public class PBEKeySpec
implements KeySpec {
    private int iterationCount;
    private int keyLength;
    private char[] password;
    private byte[] salt;
    private boolean passwordValid = true;

    public PBEKeySpec(char[] password) {
        this.setPassword(password);
        this.salt = null;
        this.iterationCount = 0;
        this.keyLength = 0;
    }

    public PBEKeySpec(char[] password, byte[] salt, int iterationCount) {
        this.setPassword(password);
        this.setSalt(salt);
        this.setIterationCount(iterationCount);
        this.keyLength = 0;
    }

    public PBEKeySpec(char[] password, byte[] salt, int iterationCount, int keyLength) {
        this.setPassword(password);
        this.setSalt(salt);
        this.setIterationCount(iterationCount);
        this.setKeyLength(keyLength);
    }

    public final void clearPassword() {
        if (this.password == null) {
            return;
        }
        int i = 0;
        while (i < this.password.length) {
            this.password[i] = '\u0000';
            ++i;
        }
        this.passwordValid = false;
    }

    public final int getIterationCount() {
        return this.iterationCount;
    }

    public final int getKeyLength() {
        return this.keyLength;
    }

    public final char[] getPassword() {
        if (!this.passwordValid) {
            throw new IllegalStateException("clearPassword() has been called, the password is no longer valid");
        }
        return (char[])this.password.clone();
    }

    public final byte[] getSalt() {
        if (this.salt != null) {
            return (byte[])this.salt.clone();
        }
        return null;
    }

    private void setPassword(char[] password) {
        this.password = password != null ? (char[])password.clone() : new char[0];
        this.passwordValid = true;
    }

    private void setSalt(byte[] salt) {
        if (salt.length == 0) {
            throw new IllegalArgumentException("salt MUST NOT be an empty byte array");
        }
        this.salt = (byte[])salt.clone();
    }

    private void setIterationCount(int iterationCount) {
        if (iterationCount < 0) {
            throw new IllegalArgumentException("iterationCount MUST be positive");
        }
        this.iterationCount = iterationCount;
    }

    private void setKeyLength(int keyLength) {
        if (keyLength < 0) {
            throw new IllegalArgumentException("keyLength MUST be positive");
        }
        this.keyLength = keyLength;
    }
}

