/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.net.ssl.provider;

import gnu.javax.net.ssl.provider.CipherSuite;
import gnu.javax.net.ssl.provider.ProtocolVersion;
import gnu.javax.net.ssl.provider.SSLContextImpl;
import gnu.javax.net.ssl.provider.SSLEngineImpl;
import gnu.javax.net.ssl.provider.SSLSocketImpl;
import java.io.IOException;
import javax.net.ssl.SSLServerSocket;

public class SSLServerSocketImpl
extends SSLServerSocket {
    private final SSLContextImpl contextImpl;
    private boolean enableSessionCreation;
    private String[] enabledCipherSuites;
    private String[] enabledProtocols;
    private boolean needClientAuth;
    private boolean wantClientAuth;
    private boolean clientMode;

    public SSLServerSocketImpl(SSLContextImpl contextImpl) throws IOException {
        this.contextImpl = contextImpl;
        this.enableSessionCreation = true;
        this.enabledCipherSuites = SSLEngineImpl.defaultSuites();
        this.enabledProtocols = new String[]{ProtocolVersion.SSL_3.toString(), ProtocolVersion.TLS_1.toString(), ProtocolVersion.TLS_1_1.toString()};
        this.needClientAuth = false;
        this.wantClientAuth = false;
        this.clientMode = false;
    }

    public boolean getEnableSessionCreation() {
        return this.enableSessionCreation;
    }

    public String[] getEnabledCipherSuites() {
        return (String[])this.enabledCipherSuites.clone();
    }

    public String[] getEnabledProtocols() {
        return (String[])this.enabledProtocols.clone();
    }

    public boolean getNeedClientAuth() {
        return this.needClientAuth;
    }

    public String[] getSupportedCipherSuites() {
        return CipherSuite.availableSuiteNames().toArray(new String[0]);
    }

    public String[] getSupportedProtocols() {
        return new String[]{ProtocolVersion.SSL_3.toString(), ProtocolVersion.TLS_1.toString(), ProtocolVersion.TLS_1_1.toString()};
    }

    public boolean getUseClientMode() {
        return this.clientMode;
    }

    public boolean getWantClientAuth() {
        return this.wantClientAuth;
    }

    public void setEnableSessionCreation(boolean enabled) {
        this.enableSessionCreation = enabled;
    }

    public void setEnabledCipherSuites(String[] suites) {
        this.enabledCipherSuites = (String[])suites.clone();
    }

    public void setEnabledProtocols(String[] protocols) {
        this.enabledProtocols = (String[])protocols.clone();
    }

    public void setNeedClientAuth(boolean needAuth) {
        this.needClientAuth = needAuth;
    }

    public void setUseClientMode(boolean clientMode) {
        this.clientMode = clientMode;
    }

    public void setWantClientAuth(boolean wantAuth) {
        this.wantClientAuth = wantAuth;
    }

    public SSLSocketImpl accept() throws IOException {
        SSLSocketImpl socketImpl = new SSLSocketImpl(this.contextImpl, null, -1);
        this.implAccept(socketImpl);
        socketImpl.setEnableSessionCreation(this.enableSessionCreation);
        socketImpl.setEnabledCipherSuites(this.enabledCipherSuites);
        socketImpl.setEnabledProtocols(this.enabledProtocols);
        socketImpl.setNeedClientAuth(this.needClientAuth);
        socketImpl.setUseClientMode(this.clientMode);
        socketImpl.setWantClientAuth(this.wantClientAuth);
        return socketImpl;
    }
}

