/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.net.ssl.provider;

import gnu.javax.net.ssl.provider.Handshake;
import gnu.javax.net.ssl.provider.ProtocolVersion;
import gnu.javax.net.ssl.provider.Util;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.ByteBuffer;

final class Finished
implements Handshake.Body {
    private final ByteBuffer buffer;
    private final ProtocolVersion version;

    Finished(ByteBuffer buffer, ProtocolVersion version) {
        buffer.getClass();
        version.getClass();
        this.buffer = buffer;
        this.version = version;
    }

    public int length() {
        if (this.version.compareTo(ProtocolVersion.TLS_1) >= 0) {
            return 12;
        }
        if (this.version == ProtocolVersion.SSL_3) {
            return 36;
        }
        throw new IllegalArgumentException("length for this version unknown");
    }

    byte[] verifyData() {
        if (this.version.compareTo(ProtocolVersion.TLS_1) >= 0) {
            byte[] verify = new byte[12];
            this.buffer.position(0);
            this.buffer.get(verify);
            return verify;
        }
        throw new IllegalArgumentException("not TLSv1.0 or later");
    }

    byte[] md5Hash() {
        if (this.version == ProtocolVersion.SSL_3) {
            byte[] md5 = new byte[16];
            this.buffer.position(0);
            this.buffer.get(md5);
            return md5;
        }
        throw new IllegalArgumentException("not SSLv3");
    }

    byte[] shaHash() {
        if (this.version == ProtocolVersion.SSL_3) {
            byte[] sha = new byte[20];
            this.buffer.position(16);
            this.buffer.get(sha);
            return sha;
        }
        throw new IllegalArgumentException("not SSLv3");
    }

    void setVerifyData(byte[] verifyData, int offset) {
        if (this.version == ProtocolVersion.SSL_3) {
            throw new IllegalArgumentException("not TLSv1");
        }
        this.buffer.position(0);
        this.buffer.put(verifyData, offset, 12);
    }

    void setMD5Hash(byte[] md5, int offset) {
        if (this.version != ProtocolVersion.SSL_3) {
            throw new IllegalArgumentException("not SSLv3");
        }
        this.buffer.position(0);
        this.buffer.put(md5, offset, 16);
    }

    void setShaHash(byte[] sha, int offset) {
        if (this.version != ProtocolVersion.SSL_3) {
            throw new IllegalArgumentException("not SSLv3");
        }
        this.buffer.position(16);
        this.buffer.put(sha, offset, 20);
    }

    public String toString() {
        return this.toString(null);
    }

    public String toString(String prefix) {
        StringWriter str = new StringWriter();
        PrintWriter out = new PrintWriter(str);
        if (prefix != null) {
            out.print(prefix);
        }
        out.println("struct {");
        if (prefix != null) {
            out.print(prefix);
        }
        if (this.version.compareTo(ProtocolVersion.TLS_1) >= 0) {
            out.print("  verifyData = ");
            out.print(Util.toHexString(this.verifyData(), ':'));
        } else if (this.version == ProtocolVersion.SSL_3) {
            out.print("  md5 = ");
            out.print(Util.toHexString(this.md5Hash(), ':'));
            out.println(';');
            if (prefix != null) {
                out.print(prefix);
            }
            out.print("  sha = ");
            out.print(Util.toHexString(this.shaHash(), ':'));
        }
        out.println(';');
        if (prefix != null) {
            out.print(prefix);
        }
        out.print("} Finished;");
        return str.toString();
    }
}

