/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt.peer.swing;

import gnu.java.awt.peer.swing.SwingComponent;
import gnu.java.awt.peer.swing.SwingComponentPeer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.List;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.peer.ListPeer;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JScrollPane;

public class SwingListPeer
extends SwingComponentPeer
implements ListPeer {
    private JList jList;
    private DefaultListModel listModel = new DefaultListModel();

    public SwingListPeer(List list2) {
        this.jList = new JList(this.listModel);
        SwingList swingList = new SwingList(this.jList);
        this.init(list2, swingList);
        String[] items = list2.getItems();
        int i = 0;
        while (i < items.length) {
            this.addItem(items[i], i);
            ++i;
        }
    }

    public void add(String item, int index) {
        if (this.listModel != null) {
            this.listModel.add(index, item);
        }
    }

    public void addItem(String item, int index) {
        if (this.listModel != null) {
            this.listModel.add(index, item);
        }
    }

    public void clear() {
        if (this.listModel != null) {
            this.listModel.clear();
        }
    }

    public void delItems(int startIndex, int endIndex) {
        if (this.listModel != null) {
            this.listModel.removeRange(startIndex, endIndex);
        }
    }

    public void deselect(int index) {
        if (this.jList != null) {
            this.jList.getSelectionModel().removeSelectionInterval(index, index);
        }
    }

    public Dimension getMinimumSize(int s) {
        Dimension d = null;
        if (this.jList != null) {
            d = this.jList.getComponent(s).getMinimumSize();
        }
        return d;
    }

    public Dimension getPreferredSize(int s) {
        Dimension d = null;
        if (this.jList != null) {
            d = this.jList.getComponent(s).getPreferredSize();
        }
        return d;
    }

    public int[] getSelectedIndexes() {
        int[] sel = null;
        if (this.jList != null) {
            sel = this.jList.getSelectedIndices();
        }
        return sel;
    }

    public void makeVisible(int index) {
        if (this.jList != null) {
            Component comp = this.jList.getComponent(index);
            this.jList.scrollRectToVisible(comp.getBounds());
        }
    }

    public Dimension minimumSize(int s) {
        Dimension d = null;
        if (this.jList != null) {
            d = this.jList.getComponent(s).getMinimumSize();
        }
        return d;
    }

    public Dimension preferredSize(int s) {
        Dimension d = null;
        if (this.jList != null) {
            d = this.jList.getComponent(s).getPreferredSize();
        }
        return d;
    }

    public void removeAll() {
        if (this.jList != null) {
            this.jList.removeAll();
        }
    }

    public void select(int index) {
        if (this.jList != null) {
            this.jList.setSelectedIndex(index);
        }
    }

    public void setMultipleMode(boolean multi) {
        if (this.jList != null) {
            this.jList.setSelectionMode(multi ? 2 : 0);
        }
    }

    public void setMultipleSelections(boolean multi) {
        if (this.jList != null) {
            this.jList.setSelectionMode(multi ? 2 : 0);
        }
    }

    public void reshape(int x, int y, int width, int height) {
        if (this.swingComponent != null) {
            this.swingComponent.getJComponent().setBounds(x, y, width, height);
            this.swingComponent.getJComponent().validate();
        }
    }

    protected void peerPaint(Graphics g, boolean update) {
        super.peerPaint(g, update);
        this.jList.doLayout();
        this.jList.list();
        Rectangle r = this.getBounds();
        g.setColor(Color.RED);
        g.drawRect(r.x, r.y, r.width, r.height);
    }

    private class SwingList
    extends JScrollPane
    implements SwingComponent {
        SwingList(Component comp) {
            super(comp, 22, 32);
        }

        public JComponent getJComponent() {
            return this;
        }

        public void handleMouseEvent(MouseEvent ev) {
            ev.setSource(this);
            this.dispatchEvent(ev);
        }

        public boolean isLightweight() {
            return false;
        }

        public void handleMouseMotionEvent(MouseEvent ev) {
            this.processMouseMotionEvent(ev);
        }

        public void handleKeyEvent(KeyEvent ev) {
            this.processKeyEvent(ev);
        }

        public void handleFocusEvent(FocusEvent ev) {
            this.processFocusEvent(ev);
        }

        public Point getLocationOnScreen() {
            return SwingListPeer.this.getLocationOnScreen();
        }

        public boolean isShowing() {
            boolean retVal = false;
            if (SwingListPeer.this.awtComponent != null) {
                retVal = SwingListPeer.this.awtComponent.isShowing();
            }
            return retVal;
        }

        public Image createImage(int w, int h) {
            return SwingListPeer.this.createImage(w, h);
        }

        public Graphics getGraphics() {
            return SwingListPeer.this.getGraphics();
        }

        public Container getParent() {
            Container par = null;
            if (SwingListPeer.this.awtComponent != null) {
                par = SwingListPeer.this.awtComponent.getParent();
            }
            return par;
        }
    }
}

