/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.table;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeListener;
import java.util.Locale;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleAction;
import javax.accessibility.AccessibleComponent;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleSelection;
import javax.accessibility.AccessibleStateSet;
import javax.accessibility.AccessibleText;
import javax.accessibility.AccessibleValue;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.plaf.TableHeaderUI;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class JTableHeader
extends JComponent
implements TableColumnModelListener,
Accessible {
    private static final long serialVersionUID = 5144633983372967710L;
    protected TableColumnModel columnModel;
    protected TableColumn draggedColumn;
    protected int draggedDistance;
    boolean opaque;
    protected boolean reorderingAllowed;
    protected boolean resizingAllowed = true;
    protected TableColumn resizingColumn;
    protected JTable table;
    protected boolean updateTableInRealTime;
    TableCellRenderer cellRenderer;

    public JTableHeader() {
        this(null);
    }

    public JTableHeader(TableColumnModel cm) {
        this.columnModel = cm == null ? this.createDefaultColumnModel() : cm;
        this.initializeLocalVars();
        this.updateUI();
    }

    protected TableColumnModel createDefaultColumnModel() {
        return new DefaultTableColumnModel();
    }

    public AccessibleContext getAccessibleContext() {
        return this.accessibleContext;
    }

    public TableColumnModel getColumnModel() {
        return this.columnModel;
    }

    public TableColumn getDraggedColumn() {
        return this.draggedColumn;
    }

    public int getDraggedDistance() {
        return this.draggedDistance;
    }

    public boolean getReorderingAllowed() {
        return this.reorderingAllowed;
    }

    public boolean getResizingAllowed() {
        return this.resizingAllowed;
    }

    public TableColumn getResizingColumn() {
        return this.resizingColumn;
    }

    public JTable getTable() {
        return this.table;
    }

    public boolean getUpdateTableInRealTime() {
        return this.updateTableInRealTime;
    }

    public boolean isOpaque() {
        return this.opaque;
    }

    public void setColumnModel(TableColumnModel c) {
        this.columnModel.removeColumnModelListener(this);
        this.columnModel = c;
        this.columnModel.addColumnModelListener(this);
    }

    public void setDraggedColumn(TableColumn draggingIt) {
        this.draggedColumn = draggingIt;
    }

    public void setDraggedDistance(int d) {
        this.draggedDistance = d;
    }

    public void setOpaque(boolean o) {
        this.opaque = o;
    }

    public void setReorderingAllowed(boolean allowed) {
        this.reorderingAllowed = allowed;
    }

    public void setResizingAllowed(boolean allowed) {
        this.resizingAllowed = allowed;
    }

    public void setResizingColumn(TableColumn resizingIt) {
        this.resizingColumn = resizingIt;
    }

    public void setTable(JTable t) {
        this.table = t;
    }

    public void setUpdateTableInRealTime(boolean u) {
        this.updateTableInRealTime = u;
    }

    protected TableCellRenderer createDefaultRenderer() {
        return new DefaultTableCellRenderer();
    }

    public TableCellRenderer getDefaultRenderer() {
        return this.cellRenderer;
    }

    public void setDefaultRenderer(TableCellRenderer cellRenderer) {
        this.cellRenderer = cellRenderer;
    }

    public Rectangle getHeaderRect(int column) {
        Rectangle r = this.getTable().getCellRect(-1, column, false);
        r.height = this.getHeight();
        return r;
    }

    protected String paramString() {
        return "JTableHeader";
    }

    public String getUIClassID() {
        return "TableHeaderUI";
    }

    public TableHeaderUI getUI() {
        return (TableHeaderUI)this.ui;
    }

    public void setUI(TableHeaderUI u) {
        super.setUI(u);
    }

    public void updateUI() {
        this.setUI((TableHeaderUI)UIManager.getUI(this));
    }

    public int columnAtPoint(Point point) {
        if (this.getBounds().contains(point)) {
            return this.columnModel.getColumnIndexAtX(point.x);
        }
        return -1;
    }

    public void columnAdded(TableColumnModelEvent event) {
        this.resizeAndRepaint();
    }

    public void columnMarginChanged(ChangeEvent event) {
        this.resizeAndRepaint();
    }

    public void columnMoved(TableColumnModelEvent event) {
        this.resizeAndRepaint();
    }

    public void columnRemoved(TableColumnModelEvent event) {
        this.resizeAndRepaint();
    }

    public void columnSelectionChanged(ListSelectionEvent event) {
        this.resizeAndRepaint();
    }

    public void resizeAndRepaint() {
        this.revalidate();
        this.repaint();
    }

    protected void initializeLocalVars() {
        this.accessibleContext = new AccessibleJTableHeader();
        this.draggedColumn = null;
        this.draggedDistance = 0;
        this.opaque = true;
        this.reorderingAllowed = true;
        this.resizingAllowed = true;
        this.resizingColumn = null;
        this.table = null;
        this.updateTableInRealTime = true;
        this.cellRenderer = this.createDefaultRenderer();
    }

    protected class AccessibleJTableHeader
    extends JComponent.AccessibleJComponent {
        protected AccessibleJTableHeader() {
            super(JTableHeader.this);
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.PANEL;
        }

        public int getAccessibleChildrenCount() {
            return JTableHeader.this.table.getColumnCount();
        }

        public Accessible getAccessibleChild(int i) {
            return new AccessibleJTableHeaderEntry(i, JTableHeader.this, JTableHeader.this.table);
        }

        public Accessible getAccessibleAt(Point p) {
            return this.getAccessibleChild(JTableHeader.this.columnAtPoint(p));
        }

        protected class AccessibleJTableHeaderEntry
        extends AccessibleContext
        implements Accessible,
        AccessibleComponent {
            private int columnIndex;
            private JTableHeader parent;
            private JTable table;

            public AccessibleJTableHeaderEntry(int c, JTableHeader p, JTable t) {
                this.columnIndex = c;
                this.parent = p;
                this.table = t;
            }

            Component getColumnHeaderRenderer() {
                TableColumn tc = this.parent.getColumnModel().getColumn(this.columnIndex);
                TableCellRenderer r = tc.getHeaderRenderer();
                if (r == null) {
                    r = this.parent.getDefaultRenderer();
                }
                return r.getTableCellRendererComponent(this.table, tc.headerValue, false, false, -1, this.columnIndex);
            }

            AccessibleContext getAccessibleColumnHeaderRenderer() {
                Component c = this.getColumnHeaderRenderer();
                if (c instanceof Accessible) {
                    return c.getAccessibleContext();
                }
                return null;
            }

            public void addFocusListener(FocusListener l) {
                AccessibleContext ac = this.getAccessibleColumnHeaderRenderer();
                AccessibleComponent c = ac.getAccessibleComponent();
                if (c != null) {
                    c.addFocusListener(l);
                }
            }

            public void addPropertyChangeListener(PropertyChangeListener l) {
                AccessibleContext ac = this.getAccessibleColumnHeaderRenderer();
                if (ac != null) {
                    ac.addPropertyChangeListener(l);
                }
            }

            public boolean contains(Point p) {
                AccessibleContext ac = this.getAccessibleColumnHeaderRenderer();
                AccessibleComponent c = ac.getAccessibleComponent();
                if (c != null) {
                    return c.contains(p);
                }
                return false;
            }

            public AccessibleAction getAccessibleAction() {
                AccessibleContext ac = this.getAccessibleColumnHeaderRenderer();
                if (ac instanceof AccessibleAction) {
                    return (AccessibleAction)((Object)ac);
                }
                return null;
            }

            public Accessible getAccessibleAt(Point p) {
                AccessibleContext ac = this.getAccessibleColumnHeaderRenderer();
                AccessibleComponent c = ac.getAccessibleComponent();
                if (c != null) {
                    return c.getAccessibleAt(p);
                }
                return null;
            }

            public Accessible getAccessibleChild(int i) {
                return null;
            }

            public int getAccessibleChildrenCount() {
                return 0;
            }

            public AccessibleComponent getAccessibleComponent() {
                return this;
            }

            public AccessibleContext getAccessibleContext() {
                return this;
            }

            public String getAccessibleDescription() {
                AccessibleContext ac = this.getAccessibleColumnHeaderRenderer();
                if (ac != null) {
                    return ac.getAccessibleDescription();
                }
                return this.accessibleDescription;
            }

            public int getAccessibleIndexInParent() {
                return this.columnIndex;
            }

            public String getAccessibleName() {
                AccessibleContext ac = this.getAccessibleColumnHeaderRenderer();
                if (ac != null) {
                    return ac.getAccessibleName();
                }
                return this.accessibleName;
            }

            public AccessibleRole getAccessibleRole() {
                AccessibleContext ac = this.getAccessibleColumnHeaderRenderer();
                if (ac != null) {
                    return ac.getAccessibleRole();
                }
                return null;
            }

            public AccessibleSelection getAccessibleSelection() {
                AccessibleContext ac = this.getAccessibleColumnHeaderRenderer();
                if (ac instanceof AccessibleValue) {
                    return (AccessibleSelection)((Object)ac);
                }
                return null;
            }

            public AccessibleStateSet getAccessibleStateSet() {
                AccessibleContext ac = this.getAccessibleColumnHeaderRenderer();
                if (ac != null) {
                    return ac.getAccessibleStateSet();
                }
                return null;
            }

            public AccessibleText getAccessibleText() {
                AccessibleContext ac = this.getAccessibleColumnHeaderRenderer();
                if (ac != null) {
                    return ac.getAccessibleText();
                }
                return null;
            }

            public AccessibleValue getAccessibleValue() {
                AccessibleContext ac = this.getAccessibleColumnHeaderRenderer();
                if (ac instanceof AccessibleValue) {
                    return (AccessibleValue)((Object)ac);
                }
                return null;
            }

            public Color getBackground() {
                AccessibleContext ac = this.getAccessibleColumnHeaderRenderer();
                AccessibleComponent c = ac.getAccessibleComponent();
                if (c != null) {
                    return c.getBackground();
                }
                return null;
            }

            public Rectangle getBounds() {
                AccessibleContext ac = this.getAccessibleColumnHeaderRenderer();
                AccessibleComponent c = ac.getAccessibleComponent();
                if (c != null) {
                    return c.getBounds();
                }
                return null;
            }

            public Cursor getCursor() {
                AccessibleContext ac = this.getAccessibleColumnHeaderRenderer();
                AccessibleComponent c = ac.getAccessibleComponent();
                if (c != null) {
                    return c.getCursor();
                }
                return null;
            }

            public Font getFont() {
                AccessibleContext ac = this.getAccessibleColumnHeaderRenderer();
                AccessibleComponent c = ac.getAccessibleComponent();
                if (c != null) {
                    return c.getFont();
                }
                return null;
            }

            public FontMetrics getFontMetrics(Font f) {
                AccessibleContext ac = this.getAccessibleColumnHeaderRenderer();
                AccessibleComponent c = ac.getAccessibleComponent();
                if (c != null) {
                    return c.getFontMetrics(f);
                }
                return null;
            }

            public Color getForeground() {
                AccessibleContext ac = this.getAccessibleColumnHeaderRenderer();
                AccessibleComponent c = ac.getAccessibleComponent();
                if (c != null) {
                    return c.getForeground();
                }
                return null;
            }

            public Locale getLocale() {
                Component c = this.getColumnHeaderRenderer();
                if (c != null) {
                    return c.getLocale();
                }
                return null;
            }

            public Point getLocation() {
                AccessibleContext ac = this.getAccessibleColumnHeaderRenderer();
                AccessibleComponent c = ac.getAccessibleComponent();
                if (c != null) {
                    return c.getLocation();
                }
                return null;
            }

            public Point getLocationOnScreen() {
                AccessibleContext ac = this.getAccessibleColumnHeaderRenderer();
                AccessibleComponent c = ac.getAccessibleComponent();
                if (c != null) {
                    return c.getLocationOnScreen();
                }
                return null;
            }

            public Dimension getSize() {
                AccessibleContext ac = this.getAccessibleColumnHeaderRenderer();
                AccessibleComponent c = ac.getAccessibleComponent();
                if (c != null) {
                    return c.getSize();
                }
                return null;
            }

            public boolean isEnabled() {
                AccessibleContext ac = this.getAccessibleColumnHeaderRenderer();
                AccessibleComponent c = ac.getAccessibleComponent();
                if (c != null) {
                    return c.isEnabled();
                }
                return false;
            }

            public boolean isFocusTraversable() {
                AccessibleContext ac = this.getAccessibleColumnHeaderRenderer();
                AccessibleComponent c = ac.getAccessibleComponent();
                if (c != null) {
                    return c.isFocusTraversable();
                }
                return false;
            }

            public boolean isShowing() {
                AccessibleContext ac = this.getAccessibleColumnHeaderRenderer();
                AccessibleComponent c = ac.getAccessibleComponent();
                if (c != null) {
                    return c.isShowing();
                }
                return false;
            }

            public boolean isVisible() {
                AccessibleContext ac = this.getAccessibleColumnHeaderRenderer();
                AccessibleComponent c = ac.getAccessibleComponent();
                if (c != null) {
                    return c.isVisible();
                }
                return false;
            }

            public void removeFocusListener(FocusListener l) {
                AccessibleContext ac = this.getAccessibleColumnHeaderRenderer();
                AccessibleComponent c = ac.getAccessibleComponent();
                if (c != null) {
                    c.removeFocusListener(l);
                }
            }

            public void removePropertyChangeListener(PropertyChangeListener l) {
                AccessibleContext ac = this.getAccessibleColumnHeaderRenderer();
                if (ac != null) {
                    ac.removePropertyChangeListener(l);
                }
            }

            public void requestFocus() {
                AccessibleContext ac = this.getAccessibleColumnHeaderRenderer();
                AccessibleComponent c = ac.getAccessibleComponent();
                if (c != null) {
                    c.requestFocus();
                }
            }

            public void setAccessibleDescription(String s) {
                AccessibleContext ac = this.getAccessibleColumnHeaderRenderer();
                if (ac != null) {
                    ac.setAccessibleDescription(s);
                } else {
                    this.accessibleDescription = s;
                }
            }

            public void setAccessibleName(String s) {
                AccessibleContext ac = this.getAccessibleColumnHeaderRenderer();
                if (ac != null) {
                    ac.setAccessibleName(s);
                }
            }

            public void setBackground(Color c) {
                AccessibleContext ac = this.getAccessibleColumnHeaderRenderer();
                AccessibleComponent comp = ac.getAccessibleComponent();
                if (comp != null) {
                    comp.setBackground(c);
                }
            }

            public void setBounds(Rectangle r) {
                AccessibleContext ac = this.getAccessibleColumnHeaderRenderer();
                AccessibleComponent comp = ac.getAccessibleComponent();
                if (comp != null) {
                    comp.setBounds(r);
                }
            }

            public void setCursor(Cursor c) {
                AccessibleContext ac = this.getAccessibleColumnHeaderRenderer();
                AccessibleComponent comp = ac.getAccessibleComponent();
                if (comp != null) {
                    comp.setCursor(c);
                }
            }

            public void setEnabled(boolean b) {
                AccessibleContext ac = this.getAccessibleColumnHeaderRenderer();
                AccessibleComponent comp = ac.getAccessibleComponent();
                if (comp != null) {
                    comp.setEnabled(b);
                }
            }

            public void setFont(Font f) {
                AccessibleContext ac = this.getAccessibleColumnHeaderRenderer();
                AccessibleComponent comp = ac.getAccessibleComponent();
                if (comp != null) {
                    comp.setFont(f);
                }
            }

            public void setForeground(Color c) {
                AccessibleContext ac = this.getAccessibleColumnHeaderRenderer();
                AccessibleComponent comp = ac.getAccessibleComponent();
                if (comp != null) {
                    comp.setForeground(c);
                }
            }

            public void setLocation(Point p) {
                AccessibleContext ac = this.getAccessibleColumnHeaderRenderer();
                AccessibleComponent comp = ac.getAccessibleComponent();
                if (comp != null) {
                    comp.setLocation(p);
                }
            }

            public void setSize(Dimension d) {
                AccessibleContext ac = this.getAccessibleColumnHeaderRenderer();
                AccessibleComponent comp = ac.getAccessibleComponent();
                if (comp != null) {
                    comp.setSize(d);
                }
            }

            public void setVisible(boolean b) {
                AccessibleContext ac = this.getAccessibleColumnHeaderRenderer();
                AccessibleComponent comp = ac.getAccessibleComponent();
                if (comp != null) {
                    comp.setVisible(b);
                }
            }
        }
    }
}

