/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RenderingHints
implements Map<Object, Object>,
Cloneable {
    private HashMap<Object, Object> hintMap = new HashMap();
    public static final Key KEY_ANTIALIASING;
    public static final Object VALUE_ANTIALIAS_ON;
    public static final Object VALUE_ANTIALIAS_OFF;
    public static final Object VALUE_ANTIALIAS_DEFAULT;
    public static final Key KEY_RENDERING;
    public static final Object VALUE_RENDER_SPEED;
    public static final Object VALUE_RENDER_QUALITY;
    public static final Object VALUE_RENDER_DEFAULT;
    public static final Key KEY_DITHERING;
    public static final Object VALUE_DITHER_DISABLE;
    public static final Object VALUE_DITHER_ENABLE;
    public static final Object VALUE_DITHER_DEFAULT;
    public static final Key KEY_TEXT_ANTIALIASING;
    public static final Object VALUE_TEXT_ANTIALIAS_ON;
    public static final Object VALUE_TEXT_ANTIALIAS_OFF;
    public static final Object VALUE_TEXT_ANTIALIAS_DEFAULT;
    public static final Key KEY_FRACTIONALMETRICS;
    public static final Object VALUE_FRACTIONALMETRICS_OFF;
    public static final Object VALUE_FRACTIONALMETRICS_ON;
    public static final Object VALUE_FRACTIONALMETRICS_DEFAULT;
    public static final Key KEY_INTERPOLATION;
    public static final Object VALUE_INTERPOLATION_NEAREST_NEIGHBOR;
    public static final Object VALUE_INTERPOLATION_BILINEAR;
    public static final Object VALUE_INTERPOLATION_BICUBIC;
    public static final Key KEY_ALPHA_INTERPOLATION;
    public static final Object VALUE_ALPHA_INTERPOLATION_SPEED;
    public static final Object VALUE_ALPHA_INTERPOLATION_QUALITY;
    public static final Object VALUE_ALPHA_INTERPOLATION_DEFAULT;
    public static final Key KEY_COLOR_RENDERING;
    public static final Object VALUE_COLOR_RENDER_SPEED;
    public static final Object VALUE_COLOR_RENDER_QUALITY;
    public static final Object VALUE_COLOR_RENDER_DEFAULT;
    public static final Key KEY_STROKE_CONTROL;
    public static final Object VALUE_STROKE_DEFAULT;
    public static final Object VALUE_STROKE_NORMALIZE;
    public static final Object VALUE_STROKE_PURE;

    static {
        VALUE_ANTIALIAS_ON = "Antialiased rendering mode";
        VALUE_ANTIALIAS_OFF = "Nonantialiased rendering mode";
        VALUE_ANTIALIAS_DEFAULT = "Default antialiasing rendering mode";
        VALUE_RENDER_SPEED = "Fastest rendering methods";
        VALUE_RENDER_QUALITY = "Highest quality rendering methods";
        VALUE_RENDER_DEFAULT = "Default rendering methods";
        VALUE_DITHER_DISABLE = "Nondithered rendering mode";
        VALUE_DITHER_ENABLE = "Dithered rendering mode";
        VALUE_DITHER_DEFAULT = "Default dithering mode";
        VALUE_TEXT_ANTIALIAS_ON = "Antialiased text mode";
        VALUE_TEXT_ANTIALIAS_OFF = "Nonantialiased text mode";
        VALUE_TEXT_ANTIALIAS_DEFAULT = "Default antialiasing text mode";
        VALUE_FRACTIONALMETRICS_OFF = "Integer text metrics mode";
        VALUE_FRACTIONALMETRICS_ON = "Fractional text metrics mode";
        VALUE_FRACTIONALMETRICS_DEFAULT = "Default fractional text metrics mode";
        VALUE_INTERPOLATION_NEAREST_NEIGHBOR = "Nearest Neighbor image interpolation mode";
        VALUE_INTERPOLATION_BILINEAR = "Bilinear image interpolation mode";
        VALUE_INTERPOLATION_BICUBIC = "Bicubic image interpolation mode";
        VALUE_ALPHA_INTERPOLATION_SPEED = "Fastest alpha blending methods";
        VALUE_ALPHA_INTERPOLATION_QUALITY = "Highest quality alpha blending methods";
        VALUE_ALPHA_INTERPOLATION_DEFAULT = "Default alpha blending methods";
        VALUE_COLOR_RENDER_SPEED = "Fastest color rendering mode";
        VALUE_COLOR_RENDER_QUALITY = "Highest quality color rendering mode";
        VALUE_COLOR_RENDER_DEFAULT = "Default color rendering mode";
        VALUE_STROKE_DEFAULT = "Default stroke normalization";
        VALUE_STROKE_NORMALIZE = "Normalize strokes for consistent rendering";
        VALUE_STROKE_PURE = "Pure stroke conversion for accurate paths";
        KEY_ANTIALIASING = new KeyImpl(1, "Global antialiasing enable key", VALUE_ANTIALIAS_ON, VALUE_ANTIALIAS_OFF, VALUE_ANTIALIAS_DEFAULT);
        KEY_RENDERING = new KeyImpl(2, "Global rendering quality key", VALUE_RENDER_SPEED, VALUE_RENDER_QUALITY, VALUE_RENDER_DEFAULT);
        KEY_DITHERING = new KeyImpl(3, "Dithering quality key", VALUE_DITHER_DISABLE, VALUE_DITHER_ENABLE, VALUE_DITHER_DEFAULT);
        KEY_TEXT_ANTIALIASING = new KeyImpl(4, "Text-specific antialiasing enable key", VALUE_TEXT_ANTIALIAS_ON, VALUE_TEXT_ANTIALIAS_OFF, VALUE_TEXT_ANTIALIAS_DEFAULT);
        KEY_FRACTIONALMETRICS = new KeyImpl(5, "Fractional metrics enable key", VALUE_FRACTIONALMETRICS_OFF, VALUE_FRACTIONALMETRICS_ON, VALUE_FRACTIONALMETRICS_DEFAULT);
        KEY_INTERPOLATION = new KeyImpl(6, "Image interpolation method key", VALUE_INTERPOLATION_NEAREST_NEIGHBOR, VALUE_INTERPOLATION_BILINEAR, VALUE_INTERPOLATION_BICUBIC);
        KEY_ALPHA_INTERPOLATION = new KeyImpl(7, "Alpha blending interpolation method key", VALUE_ALPHA_INTERPOLATION_SPEED, VALUE_ALPHA_INTERPOLATION_QUALITY, VALUE_ALPHA_INTERPOLATION_DEFAULT);
        KEY_COLOR_RENDERING = new KeyImpl(8, "Color rendering quality key", VALUE_COLOR_RENDER_SPEED, VALUE_COLOR_RENDER_QUALITY, VALUE_COLOR_RENDER_DEFAULT);
        KEY_STROKE_CONTROL = new KeyImpl(9, "Stroke normalization control key", VALUE_STROKE_DEFAULT, VALUE_STROKE_NORMALIZE, VALUE_STROKE_PURE);
    }

    public RenderingHints(Map<Key, ?> init) {
        if (init != null) {
            this.putAll(init);
        }
    }

    public RenderingHints(Key key, Object value) {
        this.put(key, value);
    }

    @Override
    public int size() {
        return this.hintMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.hintMap.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        if (key == null) {
            throw new NullPointerException();
        }
        return this.hintMap.containsKey((Key)key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.hintMap.containsValue(value);
    }

    @Override
    public Object get(Object key) {
        return this.hintMap.get((Key)key);
    }

    @Override
    public Object put(Object key, Object value) {
        if (key == null || value == null) {
            throw new NullPointerException();
        }
        if (!((Key)key).isCompatibleValue(value)) {
            throw new IllegalArgumentException();
        }
        return this.hintMap.put(key, value);
    }

    public void add(RenderingHints hints) {
        this.hintMap.putAll(hints);
    }

    @Override
    public void clear() {
        this.hintMap.clear();
    }

    @Override
    public Object remove(Object key) {
        return this.hintMap.remove((Key)key);
    }

    @Override
    public void putAll(Map<?, ?> m) {
        for (Key key : m.keySet()) {
            if (key.isCompatibleValue(m.get(key))) continue;
            throw new IllegalArgumentException();
        }
        this.hintMap.putAll(m);
    }

    @Override
    public Set<Object> keySet() {
        return this.hintMap.keySet();
    }

    @Override
    public Collection<Object> values() {
        return this.hintMap.values();
    }

    @Override
    public Set<Map.Entry<Object, Object>> entrySet() {
        return Collections.unmodifiableSet(this.hintMap.entrySet());
    }

    @Override
    public boolean equals(Object o) {
        return this.hintMap.equals(o);
    }

    @Override
    public int hashCode() {
        return this.hintMap.hashCode();
    }

    public Object clone() {
        try {
            RenderingHints copy = (RenderingHints)super.clone();
            copy.hintMap = new HashMap<Object, Object>(this.hintMap);
            return copy;
        }
        catch (CloneNotSupportedException e) {
            throw (Error)new InternalError().initCause(e);
        }
    }

    public String toString() {
        return this.hintMap.toString();
    }

    public static abstract class Key {
        private final int key;

        protected Key(int privateKey) {
            this.key = privateKey;
        }

        public abstract boolean isCompatibleValue(Object var1);

        protected final int intKey() {
            return this.key;
        }

        public final int hashCode() {
            return System.identityHashCode(this);
        }

        public final boolean equals(Object other) {
            return this == other;
        }
    }

    private static final class KeyImpl
    extends Key {
        final String description;
        final Object v1;
        final Object v2;
        final Object v3;

        KeyImpl(int privateKey, String description, Object v1, Object v2, Object v3) {
            super(privateKey);
            this.description = description;
            this.v1 = v1;
            this.v2 = v2;
            this.v3 = v3;
        }

        public boolean isCompatibleValue(Object value) {
            return value == this.v1 || value == this.v2 || value == this.v3;
        }

        public String toString() {
            return this.description;
        }
    }
}

