/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.pipeline;

import gnu.xml.pipeline.EventConsumer;
import gnu.xml.pipeline.EventFilter;
import java.util.Enumeration;
import java.util.Stack;
import org.xml.sax.Attributes;
import org.xml.sax.ErrorHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.NamespaceSupport;

public class NSFilter
extends EventFilter {
    private NamespaceSupport nsStack = new NamespaceSupport();
    private Stack elementStack = new Stack();
    private boolean pushedContext;
    private String[] nsTemp = new String[3];
    private AttributesImpl attributes = new AttributesImpl();
    private boolean usedDefault;
    private static final String prefixRoot = "prefix-";

    public NSFilter(EventConsumer next) {
        super(next);
        this.setContentHandler(this);
    }

    private void fatalError(String message) throws SAXException {
        ErrorHandler handler = this.getErrorHandler();
        Locator locator = this.getDocumentLocator();
        SAXParseException e = locator == null ? new SAXParseException(message, null, null, -1, -1) : new SAXParseException(message, locator);
        if (handler != null) {
            handler.fatalError(e);
        }
        throw e;
    }

    public void startDocument() throws SAXException {
        this.elementStack.removeAllElements();
        this.nsStack.reset();
        this.pushedContext = false;
        super.startDocument();
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        if (!this.pushedContext) {
            this.nsStack.pushContext();
            this.pushedContext = true;
        }
        Enumeration e = this.nsStack.getDeclaredPrefixes();
        while (e.hasMoreElements()) {
            String declared = (String)e.nextElement();
            if (!declared.equals(prefix)) continue;
            if (uri.equals(this.nsStack.getURI(prefix))) {
                return;
            }
            this.fatalError("inconsistent binding for prefix '" + prefix + "' ... " + uri + " (was " + this.nsStack.getURI(prefix) + ")");
        }
        if (!this.nsStack.declarePrefix(prefix, uri)) {
            this.fatalError("illegal prefix declared: " + prefix);
        }
    }

    private String fixName(String ns, String l, String name, boolean isAttr) throws SAXException {
        if (("".equals(name) || name == null) && ("".equals(name = l) || name == null)) {
            this.fatalError("empty/null name");
        }
        if (this.nsStack.processName(name, this.nsTemp, isAttr) != null && this.nsTemp[0].equals(ns)) {
            return this.nsTemp[2];
        }
        int temp = name.indexOf(58);
        if (temp >= 0) {
            name = name.substring(temp + 1);
            if (!isAttr && this.nsStack.processName(name, this.nsTemp, false) != null && this.nsTemp[0].equals(ns)) {
                return this.nsTemp[2];
            }
        }
        if ("".equals(ns)) {
            if (isAttr) {
                this.fatalError("processName bug");
            }
            if (this.attributes.getIndex("xmlns") != -1) {
                this.fatalError("need to undefine default NS, but it's bound: " + this.attributes.getValue("xmlns"));
            }
            this.nsStack.declarePrefix("", "");
            this.attributes.addAttribute("", "", "xmlns", "CDATA", "");
            return name;
        }
        Enumeration e = this.nsStack.getDeclaredPrefixes();
        while (e.hasMoreElements()) {
            String prefix = (String)e.nextElement();
            String uri = this.nsStack.getURI(prefix);
            if (uri == null || !uri.equals(ns)) continue;
            return String.valueOf(prefix) + ":" + name;
        }
        temp = 0;
        while (temp >= 0) {
            String prefix = prefixRoot + temp;
            if (this.nsStack.getURI(prefix) == null) {
                this.nsStack.declarePrefix(prefix, ns);
                this.attributes.addAttribute("", "", "xmlns:" + prefix, "CDATA", ns);
                return String.valueOf(prefix) + ":" + name;
            }
            ++temp;
        }
        this.fatalError("too many prefixes genned");
        return null;
    }

    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        String aName;
        if (!this.pushedContext) {
            this.nsStack.pushContext();
        }
        this.pushedContext = false;
        int length = atts.getLength();
        int i = 0;
        while (i < length) {
            block8: {
                String prefix;
                block10: {
                    block9: {
                        aName = atts.getQName(i);
                        if (!aName.startsWith("xmlns")) break block8;
                        if (!"xmlns".equals(aName)) break block9;
                        prefix = "";
                        break block10;
                    }
                    if (aName.indexOf(58) != 5) break block8;
                    prefix = aName.substring(6);
                }
                this.startPrefixMapping(prefix, atts.getValue(i));
            }
            ++i;
        }
        this.attributes.clear();
        Enumeration e = this.nsStack.getDeclaredPrefixes();
        while (e.hasMoreElements()) {
            String prefix = (String)e.nextElement();
            this.attributes.addAttribute("", "", "".equals(prefix) ? "xmlns" : "xmlns:" + prefix, "CDATA", this.nsStack.getURI(prefix));
        }
        qName = this.fixName(uri, localName, qName, false);
        i = 0;
        while (i < length) {
            aName = atts.getQName(i);
            String aNS = atts.getURI(i);
            String aLocal = atts.getLocalName(i);
            String aType = atts.getType(i);
            String aValue = atts.getValue(i);
            if (!aName.startsWith("xmlns")) {
                aName = this.fixName(aNS, aLocal, aName, true);
                this.attributes.addAttribute(aNS, aLocal, aName, aType, aValue);
            }
            ++i;
        }
        this.elementStack.push(qName);
        super.startElement(uri, localName, qName, this.attributes);
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.nsStack.popContext();
        qName = (String)this.elementStack.pop();
        super.endElement(uri, localName, qName);
    }

    public void endPrefixMapping(String prefix) throws SAXException {
    }

    public void endDocument() throws SAXException {
        this.elementStack.removeAllElements();
        this.nsStack.reset();
        super.endDocument();
    }
}

