/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.crypto.kwa;

import gnu.java.security.util.PRNG;
import gnu.javax.crypto.kwa.IKeyWrappingAlgorithm;
import gnu.javax.crypto.kwa.KeyUnwrappingException;
import java.security.InvalidKeyException;
import java.util.Collections;
import java.util.Map;
import javax.crypto.ShortBufferException;

public abstract class BaseKeyWrappingAlgorithm
implements IKeyWrappingAlgorithm {
    protected String name;
    private PRNG prng;

    protected BaseKeyWrappingAlgorithm(String name) {
    }

    public String name() {
        return this.name;
    }

    public void init(Map attributes) throws InvalidKeyException {
        if (attributes == null) {
            attributes = Collections.EMPTY_MAP;
        }
        this.engineInit(attributes);
    }

    public int wrap(byte[] in, int inOffset, int length, byte[] out, int outOffset) throws ShortBufferException {
        if (outOffset < 0) {
            throw new IllegalArgumentException("Output offset MUST NOT be negative");
        }
        byte[] result = this.wrap(in, inOffset, length);
        if (outOffset + result.length > out.length) {
            throw new ShortBufferException();
        }
        System.arraycopy(result, 0, out, outOffset, result.length);
        return result.length;
    }

    public byte[] wrap(byte[] in, int inOffset, int length) {
        if (inOffset < 0) {
            throw new IllegalArgumentException("Input offset MUST NOT be negative");
        }
        if (length < 0) {
            throw new IllegalArgumentException("Input length MUST NOT be negative");
        }
        return this.engineWrap(in, inOffset, length);
    }

    public int unwrap(byte[] in, int inOffset, int length, byte[] out, int outOffset) throws ShortBufferException, KeyUnwrappingException {
        if (outOffset < 0) {
            throw new IllegalArgumentException("Output offset MUST NOT be negative");
        }
        byte[] result = this.engineUnwrap(in, inOffset, length);
        if (outOffset + result.length > out.length) {
            throw new ShortBufferException();
        }
        System.arraycopy(result, 0, out, outOffset, result.length);
        return result.length;
    }

    public byte[] unwrap(byte[] in, int inOffset, int length) throws KeyUnwrappingException {
        if (inOffset < 0) {
            throw new IllegalArgumentException("Input offset MUST NOT be negative");
        }
        if (length < 0) {
            throw new IllegalArgumentException("Input length MUST NOT be negative");
        }
        return this.engineUnwrap(in, inOffset, length);
    }

    protected abstract void engineInit(Map var1) throws InvalidKeyException;

    protected abstract byte[] engineWrap(byte[] var1, int var2, int var3);

    protected abstract byte[] engineUnwrap(byte[] var1, int var2, int var3) throws KeyUnwrappingException;

    protected PRNG getDefaultPRNG() {
        if (this.prng == null) {
            this.prng = PRNG.getInstance();
        }
        return this.prng;
    }
}

