/*
 * Decompiled with CFR 0.152.
 */
package gnu.classpath.tools.appletviewer;

import gnu.classpath.tools.appletviewer.TagParser;
import gnu.xml.dom.DomNode;
import gnu.xml.dom.html2.DomHTMLAppletElement;
import gnu.xml.dom.html2.DomHTMLEmbedElement;
import gnu.xml.dom.html2.DomHTMLObjectElement;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;

class AppletTag {
    URL documentbase;
    String name = "";
    String code = "";
    String codebase = "";
    ArrayList archives = new ArrayList();
    HashMap parameters = new HashMap();
    Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();

    AppletTag() {
    }

    AppletTag(DomHTMLAppletElement appElement) {
        this.name = appElement.getName();
        this.parameters.put("name", this.name);
        this.parameters.put("object", appElement.getObject());
        this.parameters.put("align", appElement.getAlign());
        this.parameters.put("alt", appElement.getAlt());
        this.parameters.put("height", appElement.getHeight());
        this.parameters.put("hspace", Integer.toString(appElement.getHspace()));
        this.parameters.put("vspace", Integer.toString(appElement.getVspace()));
        this.parameters.put("width", appElement.getWidth());
        TagParser.parseParams((DomNode)appElement, this);
        if (this.code.equals("")) {
            this.code = appElement.getCode();
            if (this.code.equals("")) {
                this.code = appElement.getCls();
            }
        }
        if (this.codebase.equals("")) {
            this.codebase = appElement.getCodeBase();
            if (this.codebase.equals("")) {
                this.codebase = appElement.getSrc();
            }
        }
        if (this.archives.size() == 0) {
            String arcs = "";
            String arch = appElement.getArchive();
            if (this.code.indexOf(".") < 0) {
                arcs = String.valueOf(this.code) + ".jar";
            }
            if (!arch.equals("")) {
                arcs = String.valueOf(arcs) + "," + arch;
            }
            if (!arcs.equals("")) {
                this.archives = TagParser.parseArchives(arcs, this);
            }
        }
    }

    AppletTag(DomHTMLEmbedElement embElement) {
        this.name = embElement.getName();
        this.parameters.put("name", this.name);
        String jobj = embElement.getJavaObject();
        if (!jobj.equals("")) {
            this.parameters.put("java_object", jobj);
        } else {
            this.parameters.put("object", embElement.getObject());
        }
        this.parameters.put("width", embElement.getWidth());
        this.parameters.put("height", embElement.getHeight());
        this.parameters.put("align", embElement.getAlign());
        this.parameters.put("alt", embElement.getAlt());
        this.parameters.put("hspace", Integer.toString(embElement.getHspace()));
        this.parameters.put("mayscript", embElement.getMayscript());
        this.parameters.put("pluginspage", embElement.getPluginsPage());
        this.parameters.put("title", embElement.getTitle());
        this.parameters.put("type", embElement.getType());
        this.parameters.put("java_type", embElement.getJavaType());
        this.parameters.put("vspace", Integer.toString(embElement.getVspace()));
        TagParser.parseParams((DomNode)embElement, this);
        if (this.codebase.equals("")) {
            String javacb = embElement.getJavaCodeBase();
            this.codebase = !javacb.equals("") ? javacb : embElement.getCodeBase();
        }
        if (this.code.equals("")) {
            String jcode = embElement.getJavaCode();
            this.code = !jcode.equals("") ? jcode : embElement.getCode();
        }
        if (this.archives.size() == 0) {
            String arcs = "";
            String jarch = embElement.getJavaArchive();
            String arch = embElement.getArchive();
            if (this.code.indexOf(".") < 0) {
                arcs = String.valueOf(this.code) + ".jar";
            }
            if (!jarch.equals("")) {
                arcs = String.valueOf(arcs) + "," + jarch;
            } else if (!arch.equals("")) {
                arcs = String.valueOf(arcs) + "," + arch;
            }
            if (!arcs.equals("")) {
                this.archives = TagParser.parseArchives(arcs, this);
            }
        }
    }

    AppletTag(DomHTMLObjectElement objElement) {
        this.name = objElement.getName();
        this.parameters.put("name", this.name);
        String jobj = objElement.getJavaObject();
        if (!jobj.equals("")) {
            this.parameters.put("java_object", jobj);
        } else {
            this.parameters.put("object", objElement.getObject());
        }
        this.parameters.put("type", objElement.getType());
        this.parameters.put("java_type", objElement.getJavaType());
        this.parameters.put("align", objElement.getAlign());
        this.parameters.put("codetype", objElement.getCodeType());
        this.parameters.put("data", objElement.getData());
        this.parameters.put("declare", Boolean.toString(objElement.getDeclare()));
        this.parameters.put("height", objElement.getHeight());
        this.parameters.put("hspace", Integer.toString(objElement.getHspace()));
        this.parameters.put("border", objElement.getBorder());
        this.parameters.put("standby", objElement.getStandby());
        this.parameters.put("tabindex", Integer.toString(objElement.getTabIndex()));
        this.parameters.put("usemap", objElement.getUseMap());
        this.parameters.put("vspace", Integer.toString(objElement.getVspace()));
        this.parameters.put("width", objElement.getWidth());
        this.parameters.put("mayscript", objElement.getMayscript());
        this.parameters.put("scriptable", objElement.getScriptable());
        TagParser.parseParams((DomNode)objElement, this);
        if (this.codebase.equals("")) {
            String javacb = objElement.getJavaCodeBase();
            this.codebase = !javacb.equals("") ? javacb : objElement.getCodeBase();
        }
        if (this.code.equals("")) {
            String jcode = objElement.getJavaCode();
            this.code = !jcode.equals("") ? jcode : objElement.getCode();
        }
        if (this.archives.size() == 0) {
            String arcs = "";
            String jarch = objElement.getJavaArchive();
            String arch = objElement.getArchive();
            if (this.code.indexOf(".") < 0) {
                arcs = String.valueOf(this.code) + ".jar";
            }
            if (!jarch.equals("")) {
                arcs = String.valueOf(arcs) + "," + jarch;
            } else if (!arch.equals("")) {
                arcs = String.valueOf(arcs) + "," + arch;
            }
            if (!arcs.equals("")) {
                this.archives = TagParser.parseArchives(arcs, this);
            }
        }
    }

    public String toString() {
        return "  name=" + this.name + "\n" + "  code=" + this.code + "\n" + "  codebase=" + this.codebase + "\n" + "  archive=" + this.archives + "\n" + "  parameters=" + this.parameters + "\n" + "  documentbase=" + this.documentbase + "\n";
    }

    Dimension getSize() {
        double p;
        Dimension size = new Dimension(320, 200);
        try {
            String widthStr = (String)this.parameters.get("width");
            if (widthStr != null && !widthStr.equals("")) {
                if (widthStr.charAt(widthStr.length() - 1) == '%') {
                    p = (double)NumberFormat.getPercentInstance(Locale.US).parse(widthStr).intValue() / 100.0;
                    size.width = (int)(p * (double)this.screenSize.width);
                } else {
                    size.width = NumberFormat.getInstance(Locale.US).parse(widthStr).intValue();
                }
            }
        }
        catch (ParseException parseException) {}
        try {
            String heightStr = (String)this.parameters.get("height");
            if (heightStr != null && !heightStr.equals("")) {
                if (heightStr.charAt(heightStr.length() - 1) == '%') {
                    p = (double)NumberFormat.getPercentInstance(Locale.US).parse(heightStr).intValue() / 100.0;
                    size.height = (int)(p * (double)this.screenSize.height);
                } else {
                    size.height = NumberFormat.getInstance(Locale.US).parse(heightStr).intValue();
                }
            }
        }
        catch (ParseException parseException) {}
        return size;
    }

    String getCodeBase() {
        return this.codebase;
    }

    ArrayList getArchives() {
        return this.archives;
    }

    String getCode() {
        return this.code;
    }

    URL getDocumentBase() {
        return this.documentbase;
    }

    String getParameter(String name) {
        return (String)this.parameters.get(name.toLowerCase());
    }

    URL prependCodeBase(String base) throws MalformedURLException {
        URL fullcodebase;
        if (this.documentbase == null) {
            this.documentbase = TagParser.db;
        }
        if (this.codebase.equals("")) {
            if (this.documentbase.getFile().endsWith(File.separator)) {
                fullcodebase = this.documentbase;
            } else {
                String dirname = this.documentbase.getFile();
                if (dirname.indexOf(".") < 0) {
                    fullcodebase = new URL(this.documentbase + File.separator);
                } else {
                    dirname = dirname.substring(0, dirname.lastIndexOf(File.separatorChar) + 1);
                    fullcodebase = new URL(this.documentbase.getProtocol(), this.documentbase.getHost(), this.documentbase.getPort(), dirname);
                }
            }
        } else {
            URL codebaseURL = new URL(this.documentbase, this.codebase);
            fullcodebase = "file".equals(codebaseURL.getProtocol()) ? (new File(codebaseURL.getFile()).isDirectory() && !this.codebase.endsWith(File.separator) ? new URL(this.documentbase, String.valueOf(this.codebase) + File.separator) : new URL(this.documentbase, this.codebase)) : (this.codebase.endsWith(File.separator) ? new URL(this.documentbase, this.codebase) : new URL(this.documentbase, String.valueOf(this.codebase) + File.separator));
        }
        return new URL(fullcodebase, base);
    }
}

