#!/bin/sh
echo 'name: feldspar-language
version: 0.6.0.2
id: feldspar-language-0.6.0.2-07232233cbd759a1f4a7c109b96a0893

license: BSD3
copyright: Copyright (c) 2012 Emil Axelsson, Gergely Dévai,
           Anders Persson, Josef Svenningsson
           Copyright (c) 2009-2011, ERICSSON AB
maintainer: Emil Axelsson <emax@chalmers.se>
            Anders Persson <anders.cj.persson@gmail.com>
stability: experimental
homepage: https://feldspar.github.com
package-url:
synopsis: A functional embedded language for DSP and parallelism
description: Feldspar (Functional Embedded Language for DSP and PARallelism)
             is an embedded DSL for describing digital signal processing
             algorithms. This package contains the language front-end and an
             interpreter.
category: Language
author: Functional programming group at Chalmers University of Technology
pkgpath: lang/feldspar/language
exposed: True
exposed-modules: Feldspar.Prelude Feldspar.Lattice Feldspar.Range
                 Feldspar.Algorithm.CRC Feldspar.Algorithm.FFT Feldspar.Core.Types
                 Feldspar.Core.Interpretation Feldspar.Core.Interpretation.Typed
                 Feldspar.Core.Constructs.Array Feldspar.Core.Constructs.Binding
                 Feldspar.Core.Constructs.Bits Feldspar.Core.Constructs.Complex
                 Feldspar.Core.Constructs.Condition
                 Feldspar.Core.Constructs.ConditionM
                 Feldspar.Core.Constructs.Conversion Feldspar.Core.Constructs.Eq
                 Feldspar.Core.Constructs.Error Feldspar.Core.Constructs.Floating
                 Feldspar.Core.Constructs.Fractional Feldspar.Core.Constructs.Future
                 Feldspar.Core.Constructs.Integral Feldspar.Core.Constructs.Literal
                 Feldspar.Core.Constructs.Logic Feldspar.Core.Constructs.Loop
                 Feldspar.Core.Constructs.Mutable
                 Feldspar.Core.Constructs.MutableArray
                 Feldspar.Core.Constructs.MutableReference
                 Feldspar.Core.Constructs.MutableToPure
                 Feldspar.Core.Constructs.NoInline Feldspar.Core.Constructs.Par
                 Feldspar.Core.Constructs.Num Feldspar.Core.Constructs.Ord
                 Feldspar.Core.Constructs.SizeProp
                 Feldspar.Core.Constructs.SourceInfo Feldspar.Core.Constructs.Trace
                 Feldspar.Core.Constructs.Tuple Feldspar.Core.Constructs.FFI
                 Feldspar.Core.Constructs.Save Feldspar.Core.Constructs
                 Feldspar.Core.Frontend.Array Feldspar.Core.Frontend.Binding
                 Feldspar.Core.Frontend.Bits Feldspar.Core.Frontend.Complex
                 Feldspar.Core.Frontend.Condition Feldspar.Core.Frontend.ConditionM
                 Feldspar.Core.Frontend.Conversion Feldspar.Core.Frontend.Eq
                 Feldspar.Core.Frontend.Error Feldspar.Core.Frontend.Floating
                 Feldspar.Core.Frontend.Fractional Feldspar.Core.Frontend.Future
                 Feldspar.Core.Frontend.Integral Feldspar.Core.Frontend.Literal
                 Feldspar.Core.Frontend.Logic Feldspar.Core.Frontend.Loop
                 Feldspar.Core.Frontend.Mutable Feldspar.Core.Frontend.MutableArray
                 Feldspar.Core.Frontend.MutableReference
                 Feldspar.Core.Frontend.MutableToPure
                 Feldspar.Core.Frontend.NoInline Feldspar.Core.Frontend.Par
                 Feldspar.Core.Frontend.Num Feldspar.Core.Frontend.Ord
                 Feldspar.Core.Frontend.Select Feldspar.Core.Frontend.SizeProp
                 Feldspar.Core.Frontend.SourceInfo Feldspar.Core.Frontend.Trace
                 Feldspar.Core.Frontend.Tuple Feldspar.Core.Frontend.FFI
                 Feldspar.Core.Frontend.Save Feldspar.Core.Frontend
                 Feldspar.Core.Collection Feldspar.Core Feldspar.BitVector
                 Feldspar.FixedPoint Feldspar.Future Feldspar.Matrix Feldspar.Option
                 Feldspar.Repa Feldspar.Stream Feldspar.Vector.Internal
                 Feldspar.Vector Feldspar.Vector.Push Feldspar.Wrap Feldspar.Par
                 Feldspar
hidden-modules:
trusted: False
import-dirs: /usr/local/lib/ghc/feldspar-language-0.6.0.2
library-dirs: /usr/local/lib/ghc/feldspar-language-0.6.0.2
hs-libraries: HSfeldspar-language-0.6.0.2
extra-libraries:
extra-ghci-libraries:
include-dirs:
includes:
depends: QuickAnnotate-0.6-6581406ce17d9b4d3eb7bd9b9b2ed5b4
         QuickCheck-2.6-7e3d016625f4d442b87676aa1ce93592
         array-0.4.0.1-6380782b62ead58fec616aa07dc0e15c
         base-4.6.0.1-185478ee9bcc4ae00bc1dbe06bac6937
         containers-0.5.0.0-3b8b869ec10d44736414ab5bea776319
         data-hash-0.1.0.0-263d820f301a41acd3318a0931fb78a7
         data-lens-2.10.2-5f2116ea9b555fcb9e4315500234a9f8
         monad-par-0.3-1d0def844b38aef21c1deca45afdf858
         mtl-2.1.2-735d9c92b4f214d454fb5168bb1eb6ee
         patch-combinators-0.1-b50edf9c97edd011245ae228955abda1
         syntactic-1.4-d383639eea89c605e42ff8b94fd381ad
         tagged-0.4.4-cba7ff9b4c1ef8e942d839e784d6f6ae
         tuple-0.2.0.1-8fb8f238577d43766f0e45c68b36e1d6
         type-level-0.2.4-2c6c93bd266901e8c2dc79667165d3d3
hugs-options:
cc-options:
ld-options:
framework-dirs:
frameworks:
haddock-interfaces: /usr/local/share/doc/hs-feldspar-language-0.6.0.2/html/feldspar-language.haddock
haddock-html: /usr/local/share/doc/hs-feldspar-language-0.6.0.2/html
' | '/usr/local/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-db' "$@"
