#!/bin/sh
echo 'name: feldspar-compiler
version: 0.6.0.2
id: feldspar-compiler-0.6.0.2-996ab47430a9454615ebf36221cb29cf

license: BSD3
copyright: Copyright (c) 2012 Emil Axelsson, Gergely Dévai,
           Anders Persson, Josef Svenningsson
           Copyright (c) 2009-2011, ERICSSON AB
maintainer: deva@inf.elte.hu
stability: experimental
homepage: https://feldspar.github.com
package-url:
synopsis: Compiler for the Feldspar language
description: Feldspar (**F**unctional **E**mbedded **L**anguage for **DSP**
             and **PAR**allelism) is an embedded DSL for describing digital
             signal processing algorithms.
             This library (FeldsparCompiler) contains a prototype compiler
             that supports C code generation from programs written in this
             language both according to ANSI C and also targeted to a real
             DSP HW.
category: Compiler
author: Feldspar group,
        Eotvos Lorand University Faculty of Informatics
pkgpath: lang/feldspar/compiler
exposed: True
exposed-modules: Feldspar.Compiler.Imperative.Representation
                 Feldspar.Compiler.Imperative.FromCore
                 Feldspar.Compiler.Imperative.FromCore.Array
                 Feldspar.Compiler.Imperative.FromCore.Binding
                 Feldspar.Compiler.Imperative.FromCore.Condition
                 Feldspar.Compiler.Imperative.FromCore.ConditionM
                 Feldspar.Compiler.Imperative.FromCore.Error
                 Feldspar.Compiler.Imperative.FromCore.Future
                 Feldspar.Compiler.Imperative.FromCore.Interpretation
                 Feldspar.Compiler.Imperative.FromCore.Literal
                 Feldspar.Compiler.Imperative.FromCore.Loop
                 Feldspar.Compiler.Imperative.FromCore.Mutable
                 Feldspar.Compiler.Imperative.FromCore.MutableToPure
                 Feldspar.Compiler.Imperative.FromCore.NoInline
                 Feldspar.Compiler.Imperative.FromCore.Par
                 Feldspar.Compiler.Imperative.FromCore.Primitive
                 Feldspar.Compiler.Imperative.FromCore.SizeProp
                 Feldspar.Compiler.Imperative.FromCore.SourceInfo
                 Feldspar.Compiler.Imperative.FromCore.Tuple
                 Feldspar.Compiler.Imperative.FromCore.FFI
                 Feldspar.Compiler.Imperative.FromCore.Save
                 Feldspar.Compiler.Imperative.Frontend
                 Feldspar.Compiler.Imperative.TransformationInstance
                 Feldspar.Compiler.Imperative.Plugin.CollectFreeVars
                 Feldspar.Compiler.Imperative.Plugin.ConstantFolding
                 Feldspar.Compiler.Imperative.Plugin.Free
                 Feldspar.Compiler.Imperative.Plugin.IVars
                 Feldspar.Compiler.Imperative.Plugin.Unroll
                 Feldspar.Compiler.Imperative.Plugin.Naming
                 Feldspar.Compiler.Backend.C.CodeGeneration
                 Feldspar.Compiler.Backend.C.Plugin.PrettyPrint
                 Feldspar.Compiler.Backend.C.Plugin.Locator
                 Feldspar.Compiler.Backend.C.Plugin.BlockProgramHandler
                 Feldspar.Compiler.Backend.C.Plugin.TypeCorrector
                 Feldspar.Compiler.Backend.C.Plugin.TypeDefinitionGenerator
                 Feldspar.Compiler.Backend.C.Plugin.VariableRoleAssigner
                 Feldspar.Compiler.Backend.C.Plugin.Rule
                 Feldspar.Compiler.Backend.C.Library
                 Feldspar.Compiler.Backend.C.Options
                 Feldspar.Compiler.Backend.C.Platforms
                 Feldspar.Compiler.Frontend.Interactive.Interface
                 Feldspar.Compiler.Compiler Feldspar.Compiler.Error
                 Feldspar.Compiler Feldspar.Transformation
                 Feldspar.Transformation.Framework Feldspar.NameExtractor
hidden-modules:
trusted: False
import-dirs: /usr/local/lib/ghc/feldspar-compiler-0.6.0.2
library-dirs: /usr/local/lib/ghc/feldspar-compiler-0.6.0.2
hs-libraries: HSfeldspar-compiler-0.6.0.2
extra-libraries:
extra-ghci-libraries:
include-dirs: /usr/local/lib/ghc/feldspar-compiler-0.6.0.2/include
includes:
depends: MonadCatchIO-mtl-0.3.0.5-db87269a14c9e10c4e605bc41f9823f9
         ansi-terminal-0.5.5-0bcc070b48372993f61d0303d56a607e
         base-4.6.0.1-185478ee9bcc4ae00bc1dbe06bac6937
         containers-0.5.0.0-3b8b869ec10d44736414ab5bea776319
         directory-1.2.0.1-5cea89dab5fade71d74e1fcf13ee5ca4
         feldspar-language-0.6.0.2-07232233cbd759a1f4a7c109b96a0893
         filepath-1.3.0.1-edbc3d8247914b04f448e9261e7fe895
         haskell-src-exts-1.13.3-abeb587f19ec2aaae554383b23d63c44
         mtl-2.1.2-735d9c92b4f214d454fb5168bb1eb6ee
         process-1.1.0.2-a830d25f0e9fb9c610aa641b7f5b20f9
         syntactic-1.4-d383639eea89c605e42ff8b94fd381ad
hugs-options:
cc-options:
ld-options:
framework-dirs:
frameworks:
haddock-interfaces: /usr/local/share/doc/hs-feldspar-compiler-0.6.0.2/html/feldspar-compiler.haddock
haddock-html: /usr/local/share/doc/hs-feldspar-compiler-0.6.0.2/html
' | '/usr/local/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-db' "$@"
