/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.changes;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.changes.CompilationUnitReorgChange;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;

public class MoveCompilationUnitChange
extends CompilationUnitReorgChange {
    private boolean fUndoable;
    private long fStampToRestore;

    public MoveCompilationUnitChange(ICompilationUnit cu, IPackageFragment newPackage) {
        super(cu, newPackage);
        this.fStampToRestore = -1L;
    }

    private MoveCompilationUnitChange(IPackageFragment oldPackage, String cuName, IPackageFragment newPackage, long stampToRestore) {
        super(oldPackage.getHandleIdentifier(), newPackage.getHandleIdentifier(), oldPackage.getCompilationUnit(cuName).getHandleIdentifier());
        this.fStampToRestore = stampToRestore;
    }

    public String getName() {
        return Messages.format(RefactoringCoreMessages.MoveCompilationUnitChange_name, new String[]{this.getCu().getElementName(), MoveCompilationUnitChange.getPackageName(this.getDestinationPackage())});
    }

    public RefactoringStatus isValid(IProgressMonitor pm) throws CoreException {
        return super.isValid(pm, 7);
    }

    Change doPerformReorg(IProgressMonitor pm) throws CoreException {
        ICompilationUnit moved;
        IResource movedResource;
        String newName = this.getNewName();
        String name = newName == null ? this.getCu().getElementName() : newName;
        long currentStamp = -1L;
        IResource resource = this.getCu().getResource();
        if (resource != null) {
            currentStamp = resource.getModificationStamp();
        }
        this.fUndoable = !this.getDestinationPackage().getCompilationUnit(name).exists();
        this.getCu().move((IJavaElement)this.getDestinationPackage(), null, newName, true, pm);
        if (this.fStampToRestore != -1L && (movedResource = (moved = this.getDestinationPackage().getCompilationUnit(name)).getResource()) != null) {
            movedResource.revertModificationStamp(this.fStampToRestore);
        }
        if (this.fUndoable) {
            return new MoveCompilationUnitChange(this.getDestinationPackage(), this.getCu().getElementName(), this.getOldPackage(), currentStamp);
        }
        return null;
    }
}

