/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.markers.internal;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.ide.StatusUtil;
import org.eclipse.ui.views.markers.internal.MarkerMessages;
import org.eclipse.ui.views.markers.internal.Util;

class DialogMarkerProperties
extends TrayDialog {
    private static final String DIALOG_SETTINGS_SECTION = "DialogMarkerPropertiesDialogSettings";
    private IMarker marker = null;
    private IResource resource = null;
    private String type = "org.eclipse.core.resources.marker";
    private Map initialAttributes = null;
    private Text descriptionText;
    private Label creationTime;
    private Text resourceText;
    private Text folderText;
    private Text locationText;
    private boolean dirty;
    private String title;

    DialogMarkerProperties(Shell parentShell) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    DialogMarkerProperties(Shell parentShell, String title) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.title = title;
    }

    void setMarker(IMarker marker) {
        this.marker = marker;
        if (marker != null) {
            try {
                this.type = marker.getType();
            }
            catch (CoreException coreException) {}
        }
    }

    IMarker getMarker() {
        return this.marker;
    }

    public void setResource(IResource resource) {
        this.resource = resource;
    }

    IResource getResource() {
        return this.resource;
    }

    void setInitialAttributes(Map initialAttributes) {
        this.initialAttributes = initialAttributes;
    }

    Map getInitialAttributes() {
        if (this.initialAttributes == null) {
            this.initialAttributes = new HashMap();
        }
        return this.initialAttributes;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        if (this.title == null) {
            newShell.setText(MarkerMessages.propertiesDialog_title);
        } else {
            newShell.setText(this.title);
        }
    }

    protected Control createDialogArea(Composite parent) {
        if (this.marker != null) {
            this.resource = this.marker.getResource();
            try {
                this.initialAttributes = this.marker.getAttributes();
            }
            catch (CoreException coreException) {}
        } else if (this.resource == null) {
            this.resource = ResourcesPlugin.getWorkspace().getRoot();
        }
        Composite comp = (Composite)super.createDialogArea(parent);
        Composite composite = new Composite(comp, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        GridData gridData = new GridData(768);
        composite.setLayoutData((Object)gridData);
        this.initializeDialogUnits((Control)composite);
        this.createDescriptionArea(composite);
        if (this.marker != null) {
            this.createSeperator(composite);
            this.createCreationTimeArea(composite);
        }
        this.createAttributesArea(composite);
        if (this.resource != null) {
            this.createSeperator(composite);
            this.createResourceArea(composite);
        }
        this.updateDialogFromMarker();
        this.updateEnablement();
        Dialog.applyDialogFont((Control)composite);
        return composite;
    }

    protected void createSeperator(Composite parent) {
        Label seperator = new Label(parent, 0);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        seperator.setLayoutData((Object)gridData);
    }

    private void createCreationTimeArea(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText(MarkerMessages.propertiesDialog_creationTime_text);
        this.creationTime = new Label(parent, 0);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    private void createDescriptionArea(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText(MarkerMessages.propertiesDialog_description_text);
        this.descriptionText = new Text(parent, 2052);
        GridData gridData = new GridData(768);
        gridData.widthHint = this.convertHorizontalDLUsToPixels(400);
        this.descriptionText.setLayoutData((Object)gridData);
        this.descriptionText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DialogMarkerProperties.this.markDirty();
            }
        });
    }

    protected void createAttributesArea(Composite parent) {
    }

    private void createResourceArea(Composite parent) {
        Label resourceLabel = new Label(parent, 0);
        resourceLabel.setText(MarkerMessages.propertiesDialog_resource_text);
        this.resourceText = new Text(parent, 2124);
        GridData gridData = new GridData(768);
        this.resourceText.setLayoutData((Object)gridData);
        Label folderLabel = new Label(parent, 0);
        folderLabel.setText(MarkerMessages.propertiesDialog_folder_text);
        this.folderText = new Text(parent, 2124);
        gridData = new GridData(768);
        this.folderText.setLayoutData((Object)gridData);
        Label locationLabel = new Label(parent, 0);
        locationLabel.setText(MarkerMessages.propertiesDialog_location_text);
        this.locationText = new Text(parent, 2124);
        gridData = new GridData(768);
        this.locationText.setLayoutData((Object)gridData);
    }

    protected void updateDialogFromMarker() {
        if (this.marker == null) {
            this.updateDialogForNewMarker();
            return;
        }
        this.descriptionText.setText(Util.getProperty("message", this.marker));
        if (this.creationTime != null) {
            this.creationTime.setText(Util.getCreationTime(this.marker));
        }
        if (this.resourceText != null) {
            this.resourceText.setText(Util.getResourceName(this.marker));
        }
        if (this.folderText != null) {
            this.folderText.setText(Util.getContainerName(this.marker));
        }
        if (this.locationText != null) {
            String line = Util.getProperty("lineNumber", this.marker);
            if (line.equals("")) {
                this.locationText.setText("");
            } else {
                this.locationText.setText(NLS.bind((String)MarkerMessages.label_lineNumber, (Object)line));
            }
        }
        this.descriptionText.selectAll();
    }

    protected void updateDialogForNewMarker() {
        if (this.resource != null && this.resourceText != null && this.folderText != null) {
            this.resourceText.setText(this.resource.getName());
            IPath path = this.resource.getFullPath();
            int n = path.segmentCount() - 1;
            if (n > 0) {
                int len = 0;
                int i = 0;
                while (i < n) {
                    len += path.segment(i).length();
                    ++i;
                }
                if (n > 1) {
                    len += n - 1;
                }
                StringBuffer sb = new StringBuffer(len);
                int i2 = 0;
                while (i2 < n) {
                    if (i2 != 0) {
                        sb.append('/');
                    }
                    sb.append(path.segment(i2));
                    ++i2;
                }
                this.folderText.setText(sb.toString());
            }
        }
        if (this.initialAttributes != null) {
            Object description = this.initialAttributes.get("message");
            if (description != null && description instanceof String) {
                this.descriptionText.setText((String)description);
            }
            this.descriptionText.selectAll();
            Object line = this.initialAttributes.get("lineNumber");
            if (line != null && line instanceof Integer && this.locationText != null) {
                this.locationText.setText(NLS.bind((String)MarkerMessages.label_lineNumber, line));
            }
        }
    }

    protected void okPressed() {
        if (this.marker == null || Util.isEditable(this.marker)) {
            this.saveChanges();
        }
        super.okPressed();
    }

    protected void markDirty() {
        this.dirty = true;
    }

    protected boolean isDirty() {
        return this.dirty;
    }

    private void saveChanges() {
        final CoreException[] coreExceptions = new CoreException[1];
        try {
            final Map attrs = this.getMarkerAttributes();
            PlatformUI.getWorkbench().getProgressService().busyCursorWhile(new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) {
                    try {
                        monitor.beginTask("", 100);
                        ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(){

                            public void run(IProgressMonitor monitor) throws CoreException {
                                if (DialogMarkerProperties.this.marker == null) {
                                    DialogMarkerProperties.this.createMarker(monitor);
                                }
                                if (DialogMarkerProperties.this.isDirty()) {
                                    DialogMarkerProperties.this.updateMarker(monitor, attrs);
                                }
                            }
                        }, monitor);
                        monitor.done();
                    }
                    catch (CoreException e) {
                        coreExceptions[0] = e;
                    }
                }
            });
        }
        catch (InvocationTargetException e) {
            IDEWorkbenchPlugin.log(e.getMessage(), StatusUtil.newStatus(4, e.getMessage(), (Throwable)e));
            return;
        }
        catch (InterruptedException interruptedException) {}
        if (coreExceptions[0] != null) {
            ErrorDialog.openError((Shell)this.getShell(), (String)MarkerMessages.Error, null, (IStatus)coreExceptions[0].getStatus());
        }
    }

    private void updateMarker(IProgressMonitor monitor, Map attrs) throws CoreException {
        int increment = 50 / attrs.size();
        Iterator i = attrs.keySet().iterator();
        while (i.hasNext()) {
            monitor.worked(increment);
            String key = (String)i.next();
            Object val = attrs.get(key);
            this.marker.setAttribute(key, val);
        }
    }

    protected Map getMarkerAttributes() {
        HashMap<String, String> attrs = this.initialAttributes == null ? this.initialAttributes : new HashMap<String, String>();
        attrs.put("message", this.descriptionText.getText());
        return attrs;
    }

    private void createMarker(IProgressMonitor monitor) throws CoreException {
        if (this.resource == null) {
            return;
        }
        monitor.worked(10);
        this.marker = this.resource.createMarker(this.type);
        monitor.worked(40);
    }

    protected void updateEnablement() {
        this.descriptionText.setEditable(this.isEditable());
    }

    protected boolean isEditable() {
        if (this.marker == null) {
            return true;
        }
        return Util.isEditable(this.marker);
    }

    void setType(String type) {
        this.type = type;
    }

    protected IDialogSettings getDialogBoundsSettings() {
        IDialogSettings settings = IDEWorkbenchPlugin.getDefault().getDialogSettings();
        IDialogSettings section = settings.getSection(DIALOG_SETTINGS_SECTION);
        if (section == null) {
            section = settings.addNewSection(DIALOG_SETTINGS_SECTION);
        }
        return section;
    }
}

