/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui;

import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.team.internal.ccvs.core.EditorsInfo;
import org.eclipse.team.internal.ccvs.ui.CVSUIMessages;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;

public class EditorsView
extends ViewPart {
    public static final String VIEW_ID = "org.eclipse.team.ccvs.ui.EditorsView";
    private Table table;
    private TableViewer tableViewer;

    public void createPartControl(Composite parent) {
        this.table = new Table(parent, 66304);
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        GridData gridData = new GridData(1808);
        gridData.widthHint = 500;
        gridData.heightHint = 100;
        this.table.setLayoutData((Object)gridData);
        TableLayout layout = new TableLayout();
        this.table.setLayout((Layout)layout);
        this.tableViewer = new TableViewer(this.table);
        this.createColumns(this.table, layout);
        this.tableViewer.setContentProvider((IContentProvider)new EditorsContentProvider());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new EditorsLabelProvider());
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.tableViewer.getControl(), "org.eclipse.team.cvs.ui.cvs_editors_view_context");
    }

    public void setInput(EditorsInfo[] infos) {
        this.tableViewer.setInput((Object)infos);
    }

    private void createColumns(Table table, TableLayout layout) {
        TableColumn col = new TableColumn(table, 0);
        col.setResizable(true);
        col.setText(CVSUIMessages.EditorsView_file);
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(30, true));
        col = new TableColumn(table, 0);
        col.setResizable(true);
        col.setText(CVSUIMessages.EditorsView_user);
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(20, true));
        col = new TableColumn(table, 0);
        col.setResizable(true);
        col.setText(CVSUIMessages.EditorsView_date);
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(30, true));
        col = new TableColumn(table, 0);
        col.setResizable(true);
        col.setText(CVSUIMessages.EditorsView_computer);
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(20, true));
    }

    public void setFocus() {
        if (this.table != null) {
            this.table.setFocus();
        }
    }

    public Table getTable() {
        return this.table;
    }

    class EditorsContentProvider
    implements IStructuredContentProvider {
        EditorsContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return (EditorsInfo[])inputElement;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    class EditorsLabelProvider
    implements ITableLabelProvider {
        EditorsLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element == null) {
                return "";
            }
            EditorsInfo info = (EditorsInfo)element;
            String result = null;
            switch (columnIndex) {
                case 0: {
                    result = info.getFileName();
                    break;
                }
                case 1: {
                    result = info.getUserName();
                    break;
                }
                case 2: {
                    result = info.getDateString();
                    break;
                }
                case 3: {
                    result = info.getComputerName();
                }
            }
            if (result == null) {
                result = "";
            }
            return result;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }
}

