/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.menus;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.ui.internal.menus.LayoutNode;
import org.eclipse.ui.internal.menus.LeafLocationElement;
import org.eclipse.ui.internal.menus.LocationElement;
import org.eclipse.ui.internal.menus.MenuElement;
import org.eclipse.ui.internal.menus.SBar;
import org.eclipse.ui.internal.menus.SLocation;
import org.eclipse.ui.internal.menus.SPart;
import org.eclipse.ui.internal.menus.SPartMenuLayout;
import org.eclipse.ui.internal.menus.SPopup;

public final class SMenuLayout
extends SPartMenuLayout {
    private final Map partsById = new HashMap();

    static final SMenuLayout computeLayout(Collection menuElements) {
        SMenuLayout layout = new SMenuLayout();
        for (MenuElement element : menuElements) {
            try {
                SLocation[] locations = element.getLocations();
                int i = 0;
                while (i < locations.length) {
                    SLocation location = locations[i];
                    LocationElement locationElement = location.getPath();
                    if (locationElement instanceof SBar) {
                        SBar bar = (SBar)locationElement;
                        layout.addBar(element, location, bar);
                    } else if (locationElement instanceof SPopup) {
                        SPopup popup = (SPopup)locationElement;
                        layout.addPopup(element, location, popup);
                    } else if (locationElement instanceof SPart) {
                        SPart part = (SPart)locationElement;
                        layout.addPart(element, location, part);
                    }
                    ++i;
                }
            }
            catch (NotDefinedException notDefinedException) {}
        }
        return layout;
    }

    SMenuLayout() {
    }

    private final void addPart(MenuElement element, SLocation location, SPart part) throws NotDefinedException {
        LeafLocationElement locationElement;
        String partIdOrType = part.getPart();
        SPartMenuLayout layout = (SPartMenuLayout)this.partsById.get(partIdOrType);
        if (layout == null) {
            layout = new SPartMenuLayout();
            this.partsById.put(partIdOrType, layout);
        }
        if ((locationElement = part.getLocation()) instanceof SBar) {
            SBar bar = (SBar)locationElement;
            layout.addBar(element, location, bar);
        } else if (locationElement instanceof SPopup) {
            SPopup popup = (SPopup)locationElement;
            layout.addPopup(element, location, popup);
        }
    }

    public final String toString() {
        LayoutNode node;
        StringBuffer buffer = new StringBuffer();
        buffer.append(" ***** TOP-LEVEL BARS ***** \n");
        for (Map.Entry entry : this.getBarsByType().entrySet()) {
            String type = (String)entry.getKey();
            buffer.append(type);
            buffer.append('\n');
            node = (LayoutNode)entry.getValue();
            this.printNode(node, buffer, 2);
        }
        buffer.append(" ***** PART-SPECIFIC BARS ***** \n");
        for (Map.Entry entry : this.partsById.entrySet()) {
            String partId = (String)entry.getKey();
            buffer.append(partId);
            buffer.append('\n');
            SPartMenuLayout layout = (SPartMenuLayout)entry.getValue();
            buffer.append(layout.toString());
        }
        buffer.append(" ***** CONTEXT MENUS ***** \n");
        for (Map.Entry entry : this.getPopupsById().entrySet()) {
            String id = (String)entry.getKey();
            buffer.append(id);
            buffer.append('\n');
            node = (LayoutNode)entry.getValue();
            this.printNode(node, buffer, 2);
        }
        return buffer.toString();
    }
}

