/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tomcat.internal;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.UnknownHostException;
import java.util.Random;

public class SocketUtil {
    private static final Random random = new Random(System.currentTimeMillis());

    public static int findUnusedLocalPort(InetAddress address) {
        try {
            if (address == null) {
                byte[] byArray = new byte[4];
                byArray[0] = 127;
                byArray[3] = 1;
                address = InetAddress.getByAddress(byArray);
            }
        }
        catch (UnknownHostException unknownHostException) {
            return -1;
        }
        int port = SocketUtil.findUnusedPort(address, 49152, 65535);
        if (port == -1) {
            port = SocketUtil.findFreePort();
        }
        return port;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static int findUnusedPort(InetAddress address, int from, int to) {
        int i = 0;
        while (true) {
            ServerSocket ss;
            block13: {
                int n;
                if (i >= 12) {
                    return -1;
                }
                ss = null;
                int port = SocketUtil.getRandomPort(from, to);
                try {
                    ss = new ServerSocket();
                    InetSocketAddress sa = new InetSocketAddress(address, port);
                    ss.bind(sa);
                    n = ss.getLocalPort();
                    if (ss == null) return n;
                }
                catch (IOException iOException) {
                    try {
                        break block13;
                    }
                    catch (Throwable throwable) {
                        if (ss == null) throw throwable;
                        try {
                            ss.close();
                            throw throwable;
                        }
                        catch (IOException iOException2) {}
                        throw throwable;
                    }
                }
                try {
                    ss.close();
                    return n;
                }
                catch (IOException iOException) {}
                return n;
            }
            if (ss != null) {
                try {
                    ss.close();
                }
                catch (IOException iOException) {}
            }
            ++i;
        }
    }

    private static int getRandomPort(int low, int high) {
        return (int)(random.nextFloat() * (float)(high - low)) + low;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static int findFreePort() {
        ServerSocket socket;
        block10: {
            int n;
            socket = null;
            try {
                socket = new ServerSocket(0);
                n = socket.getLocalPort();
                if (socket == null) return n;
            }
            catch (IOException iOException) {
                try {
                    break block10;
                }
                catch (Throwable throwable) {
                    if (socket == null) throw throwable;
                    try {
                        socket.close();
                        throw throwable;
                    }
                    catch (IOException iOException2) {}
                    throw throwable;
                }
            }
            try {
                socket.close();
                return n;
            }
            catch (IOException iOException) {}
            return n;
        }
        if (socket == null) return -1;
        try {
            socket.close();
            return -1;
        }
        catch (IOException iOException) {}
        return -1;
    }
}

