/*******************************************************************************
 * Copyright (c) 2001, 2004 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.wst.rdb.fe.internal.ui.actions.popup;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.ui.navigator.CommonViewer;
import org.eclipse.wst.rdb.core.internal.ui.icons.ImageDescription;
import org.eclipse.wst.rdb.core.internal.ui.util.resources.ResourceLoader;
import org.eclipse.wst.rdb.fe.internal.ui.wizards.FEWizard;
import org.eclipse.wst.rdb.internal.models.sql.schema.SQLObject;

/**
 * @author ldunnell
 */
public class ForwardEngineerAction extends Action
{
    private static final String TEXT = ResourceLoader.getResourceLoader().queryString("FE_WIZARD_TITLEBAR_TEXT");
    private static final ImageDescriptor descriptor = ImageDescription.getGenerateCodeDescriptor();
    
    protected SelectionChangedEvent event;
	protected CommonViewer viewer;

	public ForwardEngineerAction()
	{
		this.setImageDescriptor(descriptor);
		this.setDisabledImageDescriptor(descriptor);
		this.setText(TEXT);
		this.setToolTipText(TEXT);
	}

	public void setCommonViewer(CommonViewer viewer)
	{
		this.viewer = viewer;
	}

	public void selectionChanged(SelectionChangedEvent event)
	{
		this.event = event;
	}

	protected List getMultipleSelection (Class type)
	{
		List linkedList = new LinkedList ();
		if (this.event.getSelection() instanceof IStructuredSelection)
		{
			for (Iterator i = ((IStructuredSelection)this.event.getSelection()).iterator(); i.hasNext();)
			{
				Object nextSelected = i.next();
				if (nextSelected instanceof IAdaptable)
				{
					linkedList.add(((IAdaptable)nextSelected).getAdapter(type));
				}
				else if (type.isAssignableFrom(nextSelected.getClass()))
				{
				    linkedList.add(nextSelected);
				}
			}
		}
		return linkedList;
	}
	
	public void run()
	{
		try
		{
			List list = this.getMultipleSelection(SQLObject.class);
			if (list.size() > 0)
			{
				Wizard wizard = new FEWizard(list);
				WizardDialog dialog = new WizardDialog(this.viewer.getControl().getShell(), wizard);
				dialog.create();
				dialog.open();
			}
		}
		catch (Exception e)
		{
			e.printStackTrace();
		}
	}
}
