/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.rdb.internal.outputview;

import java.util.Vector;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.wst.rdb.internal.outputview.OutputItem;
import org.eclipse.wst.rdb.internal.outputview.OutputView;
import org.eclipse.wst.rdb.internal.outputview.OutputViewModel;
import org.eclipse.wst.rdb.internal.outputview.OutputViewPlugin;
import org.eclipse.wst.rdb.internal.outputview.actions.RemoveAllOutputTableRow;
import org.eclipse.wst.rdb.internal.outputview.actions.RemoveOutputTableRow;

public class OutputViewActionsTable
extends TableViewer
implements IMenuListener {
    protected Table aTable;
    protected TableItem selectedTableItem;
    protected OutputViewModel model;
    protected OutputView view;

    public OutputViewActionsTable(Composite parent, OutputViewModel model, OutputView outputView) {
        super(new Table(parent, 68356));
        this.model = model;
        this.view = outputView;
        this.aTable = this.getTable();
        this.setUpTable();
        this.setLabelProvider((IBaseLabelProvider)new ActionsTableLabelProvider());
        this.setContentProvider((IContentProvider)new ActionsTableContentProvider());
        MenuManager contextMenu = new MenuManager("#PopUp");
        contextMenu.add((IContributionItem)new Separator("additions"));
        contextMenu.setRemoveAllWhenShown(true);
        contextMenu.addMenuListener((IMenuListener)this);
        Menu menu = contextMenu.createContextMenu(this.getControl());
        this.getControl().setMenu(menu);
        this.setInput(model.getActionList());
    }

    public void menuAboutToShow(IMenuManager menu) {
        RemoveOutputTableRow removeRow = new RemoveOutputTableRow(this);
        menu.add((IAction)removeRow);
        RemoveAllOutputTableRow removeAll = new RemoveAllOutputTableRow(this);
        menu.add((IAction)removeAll);
    }

    protected void setUpTable() {
        this.aTable.setLinesVisible(true);
        this.aTable.setHeaderVisible(true);
        TableColumn column = new TableColumn(this.aTable, 0);
        column.setText(OutputViewPlugin.getString("OV_TABLE_TITLE_STATUS"));
        column = new TableColumn(this.aTable, 0);
        column.setText(OutputViewPlugin.getString("OV_TABLE_TITLE_ACTION"));
        column = new TableColumn(this.aTable, 0);
        column.setText(OutputViewPlugin.getString("OV_TABLE_TITLE_NAME"));
        TableLayout layout = new TableLayout();
        ColumnWeightData data = new ColumnWeightData(33, true);
        layout.addColumnData((ColumnLayoutData)data);
        layout.addColumnData((ColumnLayoutData)data);
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(34, false));
        this.aTable.setLayout((Layout)layout);
    }

    public void removeSelectedItem() {
        int i = this.aTable.getSelectionIndex();
        if (i >= 0) {
            this.model.removeOutputItem(i);
            this.refresh();
        }
        this.view.refreshWithDefault();
    }

    public void removeAll() {
        this.model.removeAll();
        this.view.refreshWithDefault();
    }

    protected void selectDefault() {
        if (!this.model.isActionListEmpty()) {
            this.aTable.select(0);
            this.refresh();
        }
    }

    protected void selectItem(OutputItem item) {
        int i = this.model.getActionList().indexOf(item);
        if (i >= 0) {
            this.aTable.setFocus();
            this.aTable.select(i);
            this.refresh();
        }
    }

    protected void selectItem(int i) {
        if (i >= 0) {
            this.aTable.setFocus();
            this.aTable.select(i);
            this.refresh();
        }
    }

    protected int getIndex(OutputItem item) {
        return this.indexForElement(item);
    }

    public OutputItem getSelectedItem() {
        int idx = this.aTable.getSelectionIndex();
        if (idx >= 0) {
            return (OutputItem)this.model.getActionList().get(idx);
        }
        return null;
    }

    protected class ActionsTableContentProvider
    implements IStructuredContentProvider {
        protected ActionsTableContentProvider() {
        }

        public Object[] getElements(Object collection) {
            if (collection instanceof Vector) {
                return ((Vector)collection).toArray();
            }
            return null;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object old, Object newobj) {
        }
    }

    protected class ActionsTableLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        protected ActionsTableLabelProvider() {
        }

        public String getColumnText(Object outputItem, int columnIndex) {
            String colText = "";
            switch (columnIndex) {
                case 0: {
                    colText = ((OutputItem)outputItem).getStatus();
                    break;
                }
                case 1: {
                    colText = ((OutputItem)outputItem).getAction();
                    break;
                }
                case 2: {
                    colText = ((OutputItem)outputItem).getObjName();
                }
            }
            if (colText == null) {
                return "";
            }
            return colText;
        }

        public Image getColumnImage(Object outputItem, int columnIndex) {
            if (columnIndex == 0) {
                return ((OutputItem)outputItem).getStatusImage();
            }
            return null;
        }
    }
}

