/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.javascript.ui.internal.common.contentassist;

import java.util.Hashtable;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.wst.javascript.ui.internal.common.contentassist.CompletionStringNode;
import org.eclipse.wst.javascript.ui.internal.common.contentassist.JavaScriptContentAssistProcessor;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class FCContext {
    protected Hashtable ht;
    protected Node node;
    protected IndexedRegion nodeScript = null;
    protected ITextViewer itviewer = null;
    protected String path = null;

    public FCContext(CompletionStringNode csn, FCContext fccOld) {
        this.node = fccOld.node;
        this.nodeScript = fccOld.nodeScript;
        this.itviewer = fccOld.itviewer;
        String newPath = this.computePath(csn, fccOld);
        this.setPath(newPath);
        String ntf = (String)csn.getAttributesH().get("nodetagfind");
        if (ntf != null && ntf.length() > 0) {
            NodeList nl = JavaScriptContentAssistProcessor.getDescendentsByName(fccOld.node, ntf);
            Node node = this.node = nl != null && nl.getLength() > 0 ? nl.item(0) : null;
        }
        if ((ntf = (String)csn.getAttributesH().get("nodeindexfind")) != null && ntf.length() > 0) {
            int idx = Integer.parseInt(ntf);
            this.node = fccOld.node.getChildNodes().item(idx);
        }
        this.ht = (Hashtable)fccOld.ht.clone();
        Hashtable ht2 = csn.getAttributesH();
        String hval2 = (String)ht2.get("iesupport");
        String hval = (String)this.ht.get("iesupport");
        if (hval == null) {
            hval = "q";
        }
        if (hval2 == null) {
            hval2 = "q";
        }
        if (hval.equals("n") || hval2.equals("n")) {
            this.ht.put("iesupport", "n");
        } else if (hval.equals("q") || hval2.equals("q")) {
            this.ht.put("iesupport", "q");
        }
        hval2 = (String)ht2.get("nssupport");
        hval = (String)this.ht.get("nssupport");
        if (hval == null) {
            hval = "q";
        }
        if (hval2 == null) {
            hval2 = "q";
        }
        if (hval.equals("n") || hval2.equals("n")) {
            this.ht.put("nssupport", "n");
        } else if (hval.equals("q") || hval2.equals("q")) {
            this.ht.put("nssupport", "q");
        }
        hval2 = (String)ht2.get("wasjspsupport");
        hval = (String)this.ht.get("wasjspsupport");
        if (hval == null) {
            hval = "q";
        }
        if (hval2 == null) {
            hval2 = "q";
        }
        if (hval.equals("n") || hval2.equals("n")) {
            this.ht.put("wasjspsupport", "n");
        } else if (hval.equals("q") || hval2.equals("q")) {
            this.ht.put("wasjspsupport", "q");
        }
    }

    private String computePath(String oldPath, String addPath) {
        int oldLength = oldPath.length();
        int addLength = addPath.length();
        if (addPath.charAt(0) == '/' && addPath.charAt(addLength - 1) == '/') {
            return String.valueOf(oldPath) + "[]";
        }
        if (addLength < 1) {
            return oldPath;
        }
        if (oldLength > 0) {
            return String.valueOf(oldPath) + "." + addPath;
        }
        return addPath;
    }

    protected String computePath(CompletionStringNode csn, FCContext fccOld) {
        String oldPath = null;
        String addPath = null;
        oldPath = fccOld != null ? fccOld.getPath() : "";
        addPath = csn != null ? csn.getCompletionString() : "";
        return this.computePath(oldPath, addPath);
    }

    public FCContext(Node contextNode, IndexedRegion sn, Hashtable table, ITextViewer viewer) {
        this.node = contextNode;
        this.ht = table;
        this.nodeScript = sn;
        this.itviewer = viewer;
    }

    public String getAttribute(String attrname) {
        return (String)this.ht.get(attrname);
    }

    public Node getNode() {
        return this.node;
    }

    public IndexedRegion getScriptNode() {
        return this.nodeScript;
    }

    public ITextViewer getViewer() {
        return this.itviewer;
    }

    public String getPath() {
        if (this.path == null) {
            this.path = "";
        }
        return this.path;
    }

    public void setPath(String newPath) {
        this.path = newPath == null ? "" : newPath;
    }
}

