/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.wizards.sharing;

import java.lang.reflect.InvocationTargetException;
import java.util.Properties;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.ui.IConfigurationWizard;
import org.eclipse.ui.IWorkbench;
import org.tigris.subversion.subclipse.core.ISVNRepositoryLocation;
import org.tigris.subversion.subclipse.core.SVNException;
import org.tigris.subversion.subclipse.core.SVNProviderPlugin;
import org.tigris.subversion.subclipse.core.resources.LocalResourceStatus;
import org.tigris.subversion.subclipse.core.resources.SVNWorkspaceRoot;
import org.tigris.subversion.subclipse.core.util.Util;
import org.tigris.subversion.subclipse.ui.Policy;
import org.tigris.subversion.subclipse.ui.SVNUIPlugin;
import org.tigris.subversion.subclipse.ui.WorkspacePathValidator;
import org.tigris.subversion.subclipse.ui.actions.CommitAction;
import org.tigris.subversion.subclipse.ui.wizards.ConfigurationWizardMainPage;
import org.tigris.subversion.subclipse.ui.wizards.sharing.ConfigurationWizardAutoconnectPage;
import org.tigris.subversion.subclipse.ui.wizards.sharing.DirectorySelectionPage;
import org.tigris.subversion.subclipse.ui.wizards.sharing.RepositorySelectionPage;
import org.tigris.subversion.subclipse.ui.wizards.sharing.SharingWizardFinishPage;

public class SharingWizard
extends Wizard
implements IConfigurationWizard {
    private IProject project;
    private ConfigurationWizardAutoconnectPage autoconnectPage;
    private RepositorySelectionPage locationPage;
    private ConfigurationWizardMainPage createLocationPage;
    private DirectorySelectionPage directoryPage;
    private SharingWizardFinishPage finishPage;
    private LocalResourceStatus projectStatus;
    private ISVNRepositoryLocation[] locations;

    public SharingWizard() {
        IDialogSettings workbenchSettings = SVNUIPlugin.getPlugin().getDialogSettings();
        IDialogSettings section = workbenchSettings.getSection("NewLocationWizard");
        if (section == null) {
            section = workbenchSettings.addNewSection("NewLocationWizard");
        }
        this.setDialogSettings(section);
        this.setNeedsProgressMonitor(true);
        this.setWindowTitle(Policy.bind("SharingWizard.title"));
    }

    public void addPages() {
        ImageDescriptor sharingImage = SVNUIPlugin.getPlugin().getImageDescriptor("wizban/newconnect_wizban.gif");
        if (this.doesSVNDirectoryExist()) {
            this.autoconnectPage = new ConfigurationWizardAutoconnectPage("autoconnectPage", Policy.bind("SharingWizard.autoConnectTitle"), sharingImage, this.projectStatus);
            this.autoconnectPage.setProject(this.project);
            this.autoconnectPage.setDescription(Policy.bind("SharingWizard.autoConnectTitleDescription"));
            this.addPage((IWizardPage)this.autoconnectPage);
        } else {
            IRunnableWithProgress runnable = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    SharingWizard.this.locations = SVNUIPlugin.getPlugin().getRepositoryManager().getKnownRepositoryLocations(monitor);
                }
            };
            try {
                new ProgressMonitorDialog(this.getShell()).run(true, false, runnable);
            }
            catch (Exception e) {
                SVNUIPlugin.openError(this.getShell(), null, null, e, 2);
            }
            if (this.locations.length > 0) {
                this.locationPage = new RepositorySelectionPage("importPage", Policy.bind("SharingWizard.importTitle"), sharingImage);
                this.locationPage.setDescription(Policy.bind("SharingWizard.importTitleDescription"));
                this.addPage((IWizardPage)this.locationPage);
            }
            this.createLocationPage = new ConfigurationWizardMainPage("createLocationPage", Policy.bind("SharingWizard.enterInformation"), sharingImage);
            this.createLocationPage.setDescription(Policy.bind("SharingWizard.enterInformationDescription"));
            this.addPage((IWizardPage)this.createLocationPage);
            this.createLocationPage.setDialogSettings(this.getDialogSettings());
            this.directoryPage = new DirectorySelectionPage("modulePage", Policy.bind("SharingWizard.enterModuleName"), sharingImage);
            this.directoryPage.setDescription(Policy.bind("SharingWizard.enterModuleNameDescription"));
            this.addPage((IWizardPage)this.directoryPage);
            this.finishPage = new SharingWizardFinishPage("finishPage", Policy.bind("SharingWizard.readyToFinish"), sharingImage);
            this.finishPage.setDescription(Policy.bind("SharingWizard.readyToFinishDescription"));
            this.addPage((IWizardPage)this.finishPage);
        }
    }

    public boolean canFinish() {
        IWizardPage page = this.getContainer().getCurrentPage();
        if (page == this.directoryPage) {
            return this.directoryPage.useProjectName() || this.directoryPage.getDirectoryName() != null;
        }
        if (page == this.finishPage) {
            return true;
        }
        return super.canFinish();
    }

    public IWizardPage getNextPage(IWizardPage page) {
        if (page == this.autoconnectPage) {
            return null;
        }
        if (page == this.locationPage) {
            if (this.locationPage.getLocation() == null) {
                return this.createLocationPage;
            }
            return this.directoryPage;
        }
        if (page == this.createLocationPage) {
            return this.directoryPage;
        }
        if (page == this.directoryPage) {
            return this.finishPage;
        }
        return null;
    }

    public boolean performFinish() {
        if (!WorkspacePathValidator.validateWorkspacePath()) {
            return true;
        }
        final boolean[] result = new boolean[]{true};
        try {
            final boolean[] doSync = new boolean[1];
            final boolean[] projectExists = new boolean[1];
            this.getContainer().run(true, true, new IRunnableWithProgress(){

                /*
                 * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
                 * Unable to fully structure code
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public void run(IProgressMonitor monitor) throws InvocationTargetException {
                    try {
                        try {
                            block20: {
                                block21: {
                                    block19: {
                                        monitor.beginTask("", 100);
                                        if (SharingWizard.access$1(SharingWizard.this) == null || SharingWizard.access$2(SharingWizard.this) == null) break block21;
                                        isPreviouslyKnown = SVNProviderPlugin.getPlugin().getRepositories().isKnownRepository(SharingWizard.access$2(SharingWizard.this).getUrlString());
                                        validate = SharingWizard.access$1(SharingWizard.this).getValidate();
                                        if (validate && !isPreviouslyKnown) {
                                            location = SVNProviderPlugin.getPlugin().getRepository(SharingWizard.access$2(SharingWizard.this).getUrlString());
                                            try {
                                                location.validateConnection((IProgressMonitor)new SubProgressMonitor(monitor, 50));
                                            }
                                            catch (TeamException e) {
                                                keep = new boolean[1];
                                                SharingWizard.this.getShell().getDisplay().syncExec(new Runnable(this, keep, e){
                                                    final /* synthetic */ 2 this$1;
                                                    private final /* synthetic */ boolean[] val$keep;
                                                    private final /* synthetic */ TeamException val$e;
                                                    {
                                                        this.this$1 = var1_1;
                                                        this.val$keep = blArray;
                                                        this.val$e = teamException;
                                                    }

                                                    public void run() {
                                                        this.val$keep[0] = MessageDialog.openQuestion((Shell)2.access$0(this.this$1).getContainer().getShell(), (String)Policy.bind("SharingWizard.validationFailedTitle"), (String)Policy.bind("SharingWizard.validationFailedText", new Object[]{this.val$e.getStatus().getMessage()}));
                                                    }
                                                });
                                                if (keep[0]) break block19;
                                                try {
                                                    if (!isPreviouslyKnown) {
                                                        SVNProviderPlugin.getPlugin().getRepositories().disposeRepository(location);
                                                    }
                                                }
                                                catch (TeamException e1) {
                                                    SVNUIPlugin.openError(SharingWizard.this.getContainer().getShell(), Policy.bind("exception"), null, e1, 1);
                                                }
                                                result[0] = false;
lbl25:
                                                // 3 sources

                                                while (true) {
                                                    var8_16 = null;
                                                    monitor.done();
                                                    return;
                                                }
                                            }
                                        }
                                    }
                                    SVNWorkspaceRoot.setSharing((IProject)SharingWizard.access$3(SharingWizard.this), (IProgressMonitor)new SubProgressMonitor(monitor, 50));
                                    ** GOTO lbl-1000
                                }
                                doSync[0] = true;
                                location = null;
                                isKnown = false;
                                try {
                                    location = SharingWizard.this.getLocation();
                                    isKnown = SVNProviderPlugin.getPlugin().getRepositories().isKnownRepository(location.getLocation());
                                    SVNWorkspaceRoot.getSVNFolderFor((IContainer)SharingWizard.access$3(SharingWizard.this)).unmanage(null);
                                    remoteDirectoryName = SharingWizard.access$4(SharingWizard.this);
                                    folder = location.getRemoteFolder(remoteDirectoryName);
                                    if (folder.exists((IProgressMonitor)new SubProgressMonitor(monitor, 50))) {
                                        projectExists[0] = true;
                                        sync = new boolean[]{true};
                                        if (SharingWizard.access$1(SharingWizard.this) == null) {
                                            SharingWizard.this.getShell().getDisplay().syncExec(new Runnable(this, sync){
                                                final /* synthetic */ 2 this$1;
                                                private final /* synthetic */ boolean[] val$sync;
                                                {
                                                    this.this$1 = var1_1;
                                                    this.val$sync = blArray;
                                                }

                                                public void run() {
                                                    this.val$sync[0] = false;
                                                    MessageDialog.openError((Shell)2.access$0(this.this$1).getShell(), (String)Policy.bind("SharingWizard.couldNotImport"), (String)Policy.bind("SharingWizard.couldNotImportLong", SharingWizard.access$4(2.access$0(this.this$1))));
                                                }
                                            });
                                        }
                                        result[0] = sync[0];
                                        doSync[0] = sync[0];
                                    }
                                    break block20;
                                }
                                catch (TeamException e) {
                                    SVNUIPlugin.openError(SharingWizard.this.getShell(), null, null, e, 1);
                                    result[0] = false;
                                    doSync[0] = false;
                                }
                                ** continue;
                            }
                            if (!isKnown) {
                                SVNProviderPlugin.getPlugin().getRepositories().addOrUpdateRepository(location);
                            }
                            SVNWorkspaceRoot.shareProject((ISVNRepositoryLocation)location, (IProject)SharingWizard.access$3(SharingWizard.this), (String)SharingWizard.access$4(SharingWizard.this), (String)SharingWizard.access$5(SharingWizard.this).getComment(), (IProgressMonitor)new SubProgressMonitor(monitor, 50));
                            try {
                                SharingWizard.access$3(SharingWizard.this).refreshLocal(2, (IProgressMonitor)new SubProgressMonitor(monitor, 50));
                            }
                            catch (CoreException ce) {
                                throw new TeamException(ce.getStatus());
                            }
                        }
                        catch (TeamException e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                    catch (Throwable var9_19) {
                        var8_17 = null;
                        monitor.done();
                        throw var9_19;
                    }
lbl-1000:
                    // 2 sources

                    {
                        var8_18 = null;
                    }
                    monitor.done();
                }

                static /* synthetic */ SharingWizard access$0(2 var0) {
                    return var0.SharingWizard.this;
                }
            });
            if (this.autoconnectPage == null || this.projectStatus == null) {
                CommitAction commitAction = new CommitAction(this.finishPage.getComment());
                commitAction.setSharing(true);
                IResource[] selectedResources = new IResource[]{this.project};
                commitAction.setSelectedResources(selectedResources);
                commitAction.run(null);
            }
        }
        catch (InterruptedException interruptedException) {
            return true;
        }
        catch (InvocationTargetException e) {
            SVNUIPlugin.openError(this.getContainer().getShell(), null, null, e);
        }
        return result[0];
    }

    protected ISVNRepositoryLocation getLocation() throws TeamException {
        ISVNRepositoryLocation location;
        if (this.autoconnectPage != null) {
            return this.autoconnectPage.getLocation();
        }
        if (this.locationPage != null && (location = this.locationPage.getLocation()) != null) {
            return location;
        }
        this.getShell().getDisplay().syncExec(new Runnable(){

            public void run() {
                SharingWizard.this.createLocationPage.finish((IProgressMonitor)new NullProgressMonitor());
            }
        });
        Properties properties = this.createLocationPage.getProperties();
        ISVNRepositoryLocation location2 = SVNProviderPlugin.getPlugin().getRepositories().createRepository(properties);
        return location2;
    }

    private String getRemoteDirectoryName() {
        if (this.autoconnectPage != null) {
            return Util.getLastSegment((String)this.autoconnectPage.getSharingStatus().getUrlString());
        }
        String moduleName = this.directoryPage.getDirectoryName();
        if (moduleName == null) {
            moduleName = this.project.getName();
        }
        return moduleName;
    }

    public void init(IWorkbench workbench, IProject project) {
        this.project = project;
    }

    private boolean doesSVNDirectoryExist() {
        boolean isSVNFolder = false;
        try {
            this.projectStatus = SVNWorkspaceRoot.peekResourceStatusFor((IResource)this.project);
            isSVNFolder = this.projectStatus != null && this.projectStatus.hasRemote();
        }
        catch (SVNException e) {
            Shell shell = null;
            if (this.getContainer() != null) {
                shell = this.getContainer().getShell();
            }
            SVNUIPlugin.openError(shell, null, null, e);
        }
        return isSVNFolder;
    }

    public IProject getProject() {
        return this.project;
    }

    static /* synthetic */ ConfigurationWizardAutoconnectPage access$1(SharingWizard sharingWizard) {
        return sharingWizard.autoconnectPage;
    }

    static /* synthetic */ LocalResourceStatus access$2(SharingWizard sharingWizard) {
        return sharingWizard.projectStatus;
    }

    static /* synthetic */ IProject access$3(SharingWizard sharingWizard) {
        return sharingWizard.project;
    }

    static /* synthetic */ String access$4(SharingWizard sharingWizard) {
        return sharingWizard.getRemoteDirectoryName();
    }

    static /* synthetic */ SharingWizardFinishPage access$5(SharingWizard sharingWizard) {
        return sharingWizard.finishPage;
    }
}

